<?php
/*
  Application Developed By Abhinav Software
  Website: http://abhinavsoftware.com
  Email: contact@abhinavsoftware.com
  Developer: Ankur Gupta (ankurgupta555@gmail.com)
  Copyright Ankur Gupta

  For licensing and terms of use please read license.txt file
 */
/**
 * This is the model class for table "menuitems".
 *
 * The followings are the available columns in table 'menuitems':
 * @property integer $mitem_id
 * @property string $mitem_title
 * @property string $mitem_type
 * @property integer $mitem_order
 * @property string $mitem_target
 * @property string $mitem_data
 * @property integer $mitem_pid
 * @property integer $m_id
 */
class Menuitem extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Menuitem the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'menuitems';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('mitem_title, mitem_type, mitem_order, mitem_data, mitem_pid, m_id', 'required'),
			array('mitem_order, mitem_pid, m_id', 'numerical', 'integerOnly'=>true),
			array('mitem_title, mitem_type', 'length', 'max'=>255),
			array('mitem_target', 'length', 'max'=>7),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('mitem_id, mitem_title, mitem_type, mitem_order, mitem_target, mitem_data, mitem_pid, m_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'rSubMenuitem' => array(self::HAS_MANY, 'Menuitem', 'mitem_pid'),                    
                    'rParentMenuitem' => array(self::BELONGS_TO, 'Menuitem', 'mitem_pid'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mitem_id' => 'Mitem',
			'mitem_title' => 'Mitem Title',
			'mitem_type' => 'Mitem Type',
			'mitem_order' => 'Mitem Order',
			'mitem_target' => 'Mitem Target',
			'mitem_data' => 'Mitem Data',
			'mitem_pid' => 'Mitem Pid',
			'm_id' => 'M',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('mitem_id',$this->mitem_id);
		$criteria->compare('mitem_title',$this->mitem_title,true);
		$criteria->compare('mitem_type',$this->mitem_type,true);
		$criteria->compare('mitem_order',$this->mitem_order);
		$criteria->compare('mitem_target',$this->mitem_target,true);
		$criteria->compare('mitem_data',$this->mitem_data,true);
		$criteria->compare('mitem_pid',$this->mitem_pid);
		$criteria->compare('m_id',$this->m_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
      
    const MOVE_UP = "up";
    const MOVE_DOWN = "down";

    public function getTree($mid, $pid = 0, $sep = "―", $level = 0) {
        $cri = new CDbCriteria();
        $cri->condition = "mitem_pid = :mitem_pid AND m_id=:m_id";
        $cri->params = array(":mitem_pid" => $pid, ":m_id" => $mid);
        $cri->order = "mitem_order ASC";
        $models = Menuitem::model()->findAll($cri);
        $data = array();
        if (count($models) > 0) {
            foreach ($models as $model) {

                $data[$model->mitem_id] = str_repeat($sep, $level) . $model->mitem_title;
                $subs = $this->getTree($mid, $model->mitem_id, $sep, $level + 1);
                if (count($subs) > 0) {
                    $data = $data + $subs;
                }
            }
        }
        return $data;
    }

    /**
     * Returns maximum order under specific menu parent id.
     * @param int $pid
     * @param string $menuName
     * @return int
     */
    public function getMaxOrderIndex($mitem_pid) {
        $db = Yii::app()->db->createCommand();
        $maxorder = $db->select("COALESCE(MAX(mitem_order),0) as maxorder")
                ->from($this->tableName())
                ->where("mitem_pid = :mitem_pid", array(":mitem_pid" => $mitem_pid))
                ->queryScalar();
        return $maxorder;
    }

    /**
     * Moves the menu item in up and down direction
     * @param int $id
     * @param string $direction
     * @return boolean
     */
    public function move($id, $direction) {
        $model = Menuitem::model()->findByPk($id);
        if ($direction == Menuitem::MOVE_UP) {
            $minorder = 1;
            $nextorder = $model->mitem_order - 1;
            if ($nextorder >= $minorder) {
                $nextmodel = Menuitem::model()
                        ->find("mitem_order = :mitem_order AND mitem_pid=:mitem_pid", array(":mitem_order" => $nextorder, ":mitem_pid" => $model->mitem_pid));

                $nextmodel->mitem_order = $model->mitem_order;
                $model->mitem_order = $model->mitem_order - 1;
                $nextmodel->save();
                $model->save();
            }
        } else if ($direction == Menuitem::MOVE_DOWN) {
            $maxorder = Menuitem::model()->getMaxOrderIndex($model->mitem_pid);
            $nextorder = $model->mitem_order + 1;
            if ($nextorder <= $maxorder) {
                $nextmodel = Menuitem::model()
                        ->find("mitem_order = :mitem_order AND mitem_pid=:mitem_pid", array(":mitem_order" => $nextorder, ":mitem_pid" => $model->mitem_pid));
                $nextmodel->mitem_order = $nextmodel->mitem_order - 1;
                $nextmodel->save();
                $model->mitem_order = $model->mitem_order + 1;
                if ($model->validate()) {
                    $model->save();
                }
            }
        }
    }
 
}