<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
/**
 * This is the model class for table "qacaptcha_questions".
 *
 * The followings are the available columns in table 'qacaptcha_questions':
 * @property string $qa_id
 * @property string $qa_question
 * @property string $qa_answer
 * @property integer $qa_casesensitive
 */
class QACaptchaQuestion extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
            return 'qacaptcha_questions';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('qa_question, qa_answer', 'required'),
                        array('qa_casesensitive', 'length', 'allowEmpty'=>true),
			array('qa_casesensitive', 'numerical', 'integerOnly'=>true),
			array('qa_question, qa_answer', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('qa_id, qa_question, qa_answer, qa_casesensitive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'qa_id' => 'Question ID',
			'qa_question' => 'Question',
			'qa_answer' => 'Answer',
			'qa_casesensitive' => 'Case Sensitive',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('qa_id',$this->qa_id,true);
		$criteria->compare('qa_question',$this->qa_question,true);
		$criteria->compare('qa_answer',$this->qa_answer,true);
		$criteria->compare('qa_casesensitive',$this->qa_casesensitive);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return QACaptchaQuestion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        public function listit($limit,$offset=0){
            $cmd = Yii::app()->db->createCommand();
            $records = $cmd->select("*")->from($this->tableName())->limit($limit)->offset($offset)->order("qa_id DESC")->queryAll();
            
            $cmd = Yii::app()->db->createCommand();
            $total = $cmd->select("COUNT(*)")->from($this->tableName())->queryScalar();
            
            return array("records"=>$records,"total"=>$total);
        }
        
        public function getRandomQuestion(){
            $cri = new CDbCriteria();
            $cri->order = "RAND()";
            $cri->limit = 1;
            $model = $this->find($cri);
            if(!is_null($model)){
                return array(
                    "qid"=>$model->qa_id,
                    "question"=>$model->qa_question,
                    "answer"=>$model->qa_answer,
                    "casesensitive"=>$model->qa_casesensitive
                );
            }
            return false;
        }
        
        public function validateAnswer($qid,$answer){
            $model = $this->findByPk($qid);
            if(is_null($model)){
                return false;
            }
            if($model->qa_casesensitive==1){
                if(trim($answer)===trim($model->qa_answer)){
                    return true;
                }
                return false;
            } else {
                if(trim(strtolower($answer))===trim(strtolower($model->qa_answer))){
                    return true;
                }
                return false;
            }
        }
}
