<?php

/**
 * This is the model class for table "users".
 *
 * The followings are the available columns in table 'users':
 * @property string $user_id
 * @property string $user_name
 * @property string $user_email
 * @property string $user_password
 * @property string $user_status
 * @property string $user_role
 * @property string $user_tasks
 */
class User extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'users';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_name, user_email, user_status, user_role', 'required'),
			array('user_name, user_email, user_password', 'length', 'max'=>255),
                        array('user_tasks', 'length', 'allowEmpty'=>true),
                        array('user_password','required','on'=>'new'),
                        array('user_password','length','allowEmpty'=>true),
                    
			array('user_status', 'length', 'max'=>8),
                        array('user_name, user_email','unique'),
			array('user_role', 'length', 'max'=>5),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('user_id, user_name, user_email, user_password, user_status, user_role, user_tasks', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}
        
        public function checkUsername(){
            
        }

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_id' => 'User',
			'user_name' => 'Username',
			'user_email' => 'Email',
			'user_password' => 'Password',
			'user_status' => 'Status',
			'user_role' => 'Role',
			'user_tasks' => 'Tasks',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_id',$this->user_id,true);
		$criteria->compare('user_name',$this->user_name,true);
		$criteria->compare('user_email',$this->user_email,true);
		$criteria->compare('user_password',$this->user_password,true);
		$criteria->compare('user_status',$this->user_status,true);
		$criteria->compare('user_role',$this->user_role,true);
		$criteria->compare('user_tasks',$this->user_tasks,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return User the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        public function authenticate($username,$password){
            $cri = new CDbCriteria();
            $cri->condition = "user_name = :username AND user_password = :password AND user_status = 'active'";
            $cri->params = array(
                ":username" => $username, ":password" => md5($password)
            );
            $model = $this->find($cri);
            if(is_null($model)){
                return false;
            } 
            return $model;
        }
}
