<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
/**
 * This is the model class for table "widgets".
 *
 * The followings are the available columns in table 'widgets':
 * @property string $wd_id
 * @property string $wd_title
 * @property string $wd_type
 * @property string $wd_order
 * @property string $wd_data
 * @property string $wd_panel
 */
class Widget extends CActiveRecord {
const MOVE_UP = "up";
      const MOVE_DOWN = "down";
    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Widget the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'widgets';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('wd_type, wd_order, wd_data, wd_panel', 'required'),
            array('wd_title', 'length', 'allowEmpty' => true),
            array('wd_title, wd_type, wd_panel', 'length', 'max' => 255),
            array('wd_order', 'length', 'max' => 10),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('wd_id, wd_title, wd_type, wd_order, wd_data, wd_panel', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'wd_id' => 'Widget Id',
            'wd_title' => 'Title',
            'wd_type' => 'Type',
            'wd_order' => 'Order',
            'wd_data' => 'Data',
            'wd_panel' => 'Panel',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('wd_id', $this->wd_id, true);
        $criteria->compare('wd_title', $this->wd_title, true);
        $criteria->compare('wd_type', $this->wd_type, true);
        $criteria->compare('wd_order', $this->wd_order, true);
        $criteria->compare('wd_data', $this->wd_data, true);
        $criteria->compare('wd_panel', $this->wd_panel, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }
   
/**
 * Returns maximum order of panel
 * @param string $wd_panel
 * @return int
 */
    public function getMaxOrderIndex($wd_panel) {
        $db = Yii::app()->db->createCommand();
        $maxorder = $db->select("COALESCE(MAX(wd_order),0) as maxorder")
                ->from($this->tableName())
                ->where("wd_panel = :wd_panel", array(":wd_panel" => $wd_panel))
                ->queryScalar();
        return $maxorder;
    }
 /**
     * Moves the menu item in up and down direction
     * @param int $id
     * @param string $direction
     * @return boolean
     */
    public function move($id, $direction) {
        $model = Widget::model()->findByPk($id);   
        if($direction==Widget::MOVE_UP){
            $minorder = 1;
            $nextorder = $model->wd_order - 1;
            if($nextorder >= $minorder){
                $nextmodel = Widget::model()
                        ->find("wd_order = :wd_order AND wd_panel=:wd_panel",
                                array(":wd_order"=>$nextorder,":wd_panel"=>$model->wd_panel));                 
                $nextmodel->wd_order = $model->wd_order;
                $model->wd_order = $model->wd_order - 1;
                $nextmodel->save();
                $model->save();
            }
        }else if($direction==Widget::MOVE_DOWN){            
            $maxorder = $this->getMaxOrderIndex($model->wd_panel); 
            $nextorder = $model->wd_order + 1;
            if($nextorder <= $maxorder){ 
                 $nextmodel = Widget::model()
                            ->find("wd_order = :wd_order AND wd_panel=:wd_panel",
                                    array(":wd_order"=>$nextorder,":wd_panel"=>$model->wd_panel));
                 $nextmodel->wd_order = $nextmodel->wd_order - 1;
                 $nextmodel->save();
                 $model->wd_order = $model->wd_order + 1;
                 if($model->validate()){ 
                    $model->save();
                 }  
            }
        }
    }

}