<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class ChangePasswordForm extends CFormModel {

    public $old_user_password;
    public $user_password;
    public $user_password2;
    public $user_id;

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('old_user_password, user_password, user_password2', 'required'),
            array('user_password2', 'compare', 'compareAttribute' => 'user_password'),
            array('old_user_password', 'check_old_password'),				
        );
    }

    public function check_old_password($attribute, $params) {
        if (!$this->hasErrors()) {
            if(User::model()->authenticate(Yii::app()->user->getState("identity")->user_name, $this->old_user_password) === false){
                $this->addError('old_user_password', 'Your existing password is incorrect.');
            }            
        }
    }

    public function attributeLabels() {
        return array(
            'old_user_password' => 'Existing Password',
            'user_password' => 'New Password',
            'user_password2' => 'Repeat New Password',
        );
    }
    
    public function save(){
        $model = User::model()->find("user_id = :id",
                array(":id"=>Yii::app()->user->Id)
                );
        $model->user_password = md5($this->user_password);
        $model->save();        
    }

}