<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class ContactForm extends CFormModel {

    public $name;
    public $email;
    public $subject;
    public $message;

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name, email, subject, message', 'required'),            
            array('email', 'email'),          
        );
    }

    public function attributeLabels() {
        return array(
            'name' => Yii::t("core",'Name'),
            'email' => Yii::t("core",'Email'),
            'subject' => Yii::t("core",'Subject'),
            'message' => Yii::t("core",'Message')
        );
    }
    
    public function send(){
        
        $message = new YiiMailer();
        $message->setSmtp(
                EmailSettings::i()->smtp_host, 
                EmailSettings::i()->smtp_port, 
                EmailSettings::i()->smtp_secure, 
                EmailSettings::i()->smtp_require_auth, 
                EmailSettings::i()->smtp_username, 
                EmailSettings::i()->smtp_password);
        $message->Body = $this->message . "<br />[ From : ".$this->name." ".$this->email." ]";
        $message->From = BasicSettings::i()->contact_email;
        $message->FromName = BasicSettings::i()->site_title;
        $message->setTo(BasicSettings::i()->contact_email);
        $message->Subject = Yii::t("core","Contact Form Message: ").$this->subject;
        $message->addAddress(BasicSettings::i()->contact_email);                
        
        if($message->send()){
            return true;
        }else{
            return $message->ErrorInfo;            
        }
         
    }
}