<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class LoginForm extends CFormModel {

    public $username;
    public $password;
    public $remember_me;
    private $_identity;

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('username, password', 'required'),
            array('remember_me', 'boolean'),
        
            array('password', 'authenticate'),
            array('username, password', 'length', 'max' => 255),
        );
    }

    public function attributeLabels() {
        return array(
            'username' => Yii::t("core",'Username'),
            'password' => Yii::t("core",'Password'),
            'remember_me' => Yii::t("core",'Remember me next time'),
        );
    }

    public function authenticate($attribute, $params) {
        if (!$this->hasErrors()) {
            $this->_identity = new UserIdentity($this->username, $this->password);
            if (!$this->_identity->authenticate()) {
                $this->addError('password', Yii::t("core",'Incorrect username or password.'));
            }
        }
    }

    public function login() {
   
        if ($this->_identity === null) {
            $this->_identity = new UserIdentity($this->username, $this->password);
            $this->_identity->authenticate();
        }
        if ($this->_identity->errorCode === UserIdentity::ERROR_NONE) {
            $duration = $this->remember_me ? 3600 * 24 * 30 : 0; // 30 days
            
           
            
            Yii::app()->user->login($this->_identity, $duration);

            return true;
        }
        else
            return false;
    }

}