<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperLoader extends AbstractModuleLoader{

  public static function getConfig() {
    return array(
      "mediaDir" => "epaper/",
    );
  }
  public static function getImports(){
    return array(
      'epaper.models.*',
      'epaper.models.forms.*',
      'epaper.nplugins.menuitems.*',
      'epaper.components.*',
      'epaper.messages.*',
      'epaper.nplugins.settings.*'
    );
  }
  public static function init(){
    $tasks = array(
      "ep_manage_categories",
      "ep_manage_editions",
      "ep_manage_scheduler",
      "ep_generate_sitemap"
    );
    TaskComponent::i()->addTask("Epaper",$tasks[0],"Manage Categories");
    TaskComponent::i()->addTask("Epaper",$tasks[1],"Manage Editions");
    TaskComponent::i()->addTask("Epaper",$tasks[2],"Manage Scheduler");
    TaskComponent::i()->addTask("Epaper",$tasks[3],"Generate Sitemap");

    AdminMenu::i()->addMenuItem("epaper","Epaper","#",$tasks);
    AdminMenu::i()->addSubMenuItem("epaper","categories","Categories",Yii::app()->createUrl("//epaper/admin/category/index"),$tasks[0]);
    AdminMenu::i()->addSubMenuItem("epaper","featured-categories","Featured Categories",Yii::app()->createUrl("//epaper/admin/category/featured"),$tasks[0]);
    AdminMenu::i()->addSubMenuItem("epaper","editions","Editions",Yii::app()->createUrl("//epaper/admin/edition/index"),$tasks[1]);
    AdminMenu::i()->addSubMenuItem("epaper","featured-editions","Featured Editions",Yii::app()->createUrl("//epaper/admin/edition/featured"),$tasks[1]);
    AdminMenu::i()->addSubMenuItem("epaper","scheduler","Scheduler",Yii::app()->createUrl("//epaper/admin/scheduler/index"),$tasks[2]);
    AdminMenu::i()->addSubMenuItem("epaper","sitemap","Sitemap",Yii::app()->createUrl("//epaper/admin/sitemap/index"),$tasks[3]);

    (new EpaperSchedulerForm())->run();

    FeedComponent::i()->onGeneratingFeed = array(new EpaperFeed(),"addItems");

  }

  public static function getUrlRewritingRules() {
    $a = parent::getUrlRewritingRules();

    if(EpaperSettings::i()->urlmode == EpaperSettings::URLMODE_ALIAS){
      $a["rules"] = array(

        "epaper/pdf/<id>"=>"epaper/default/downloadpdf",
        "epaper/share/<id>"=>"epaper/share/index",
        "epaper/print/<id>"=>"epaper/share/print",


        "epaper/viewmap/<id>.jpg"=>"epaper/default/viewmap",


        "epaper/archive/<archive>"=>"epaper/default/index",
        "epaper/archive/<archive>/page/<page>"=>"epaper/default/index",
        "epaper/category/<id>/<alias>"=>"epaper/default/index",
        "epaper/category/<id>/<alias>/page/<page>"=>"epaper/default/index",
        "epaper/category/<id>/<alias>/archive/<archive>"=>"epaper/default/index",
        "epaper/category/<id>/<alias>/archive/<archive>/page/<page>"=>"epaper/default/index",

        "epaper/edition/<id>/<alias>"=>"epaper/default/show",
        "epaper/edition/<id>/<alias>/<spid>/<spalias>"=>"epaper/default/show",

        "epaper/edition/<id>/<alias>/page/<page>"=>"epaper/default/show",
        "epaper/edition/<id>/<alias>/<spid>/<spalias>/page/<page>"=>"epaper/default/show",

        "epaper/go/<archive>/<cat_id>"=>"epaper/default/openarchive",
        "epaper/m/<id>/<alias>"=>"epaper/default/map",
        "epaper/search/<search>"=>"epaper/default/search",
        "epaper/search/<search>/page/<page>"=>"epaper/default/search",
      );
    } else {
      $a["rules"] = array(
        "/pdf/<id>"=>"epaper/default/downloadpdf",

        "/viewmap/<id>.jpg"=>"epaper/default/viewmap",

        "/archive/<archive>"=>"epaper/default/index",
        "/archive/<archive>/page/<page>"=>"epaper/default/index",
        "/category/<id>/<alias>"=>"epaper/default/index",
        "/category/<id>/<alias>/page/<page>"=>"epaper/default/index",
        "/category/<id>/<alias>/archive/<archive>"=>"epaper/default/index",
        "/category/<id>/<alias>/archive/<archive>/page/<page>"=>"epaper/default/index",
        "/edition/<id>/<alias>"=>"epaper/default/show",
        "/edition/<id>/<alias>/page/<page>"=>"epaper/default/show",
        "/go/<archive>/<cat_id>"=>"epaper/default/openarchive",
        "/m/<id>/<alias>"=>"epaper/default/map",
        "/search/<search>"=>"epaper/default/search",
        "/search/<search>/page/<page>"=>"epaper/default/search",
      );
    }
    return $a;
  }

  public static function getHomePages() {
    return array(
      "epaper/default/home" => "Epaper Featured Editions",
      "epaper/default/index2" => "Epaper Latest Editions",
      "epaper/default/singleHome" => "Epaper Latest Featured (Single)" //added from 2.1
    );
  }
}
