<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class CalenderDropdown extends CWidget{
    const RANGE_7DAYS = "7";
    const RANGE_30DAYS = "30";
    const RANGE_90DAYS = "90";
    const RANGE_180DAYS = "180";
    const RANGE_DISABLED = "0";
    
 
    
    public $count = 100;
    public $range = self::RANGE_DISABLED;
    
    
    public $class = [];
    public $name = "calender_dropdown";
    
    public $currentDate = 0;
    
 
    public function run(){
        $cri = new CDbCriteria();
        $where = " ed_status = 'public' "; $p = [];
        if($this->range != self::RANGE_DISABLED){
            $today = date("Y-m-d");
            $last = date('Y-m-d', strtotime('-'.$this->range.' days'));
            $where .= " AND ed_date >= :last AND ed_date <= :today ";
            $p[":last"] = $last;
            $p[":today"] = $today;
        }
        
        $cri->limit = $this->count;
        $cri->condition = $where;
        $cri->params = $p;
        $cri->distinct = true;
        $cri->select = "ed_date";
        $cri->order = "ed_".EpaperSettings::i()->orderby." desc";
        
        $current = "";
        $models = EpaperEdition::model()->findAll($cri,$p);
        $currentDate = $this->currentDate;
 
        foreach($models as $model){          
            $url = Yii::app()->createAbsoluteUrl("epaper/default/openarchive",[
                "archive"=>Helpers::i()->formatDate($model->ed_date,"d M Y"),
                "cat_id"=>0]);
        
            if($this->currentDate == Helpers::i()->formatDate($model->ed_date,"d M Y")){
                $current = Yii::app()->createAbsoluteUrl("epaper/default/openarchive",[
                "archive"=>Helpers::i()->formatDate($model->ed_date,"d M Y"),
                "cat_id"=>0]);
                $currentDate = $this->currentDate;
            }
            
            $title = Helpers::i()->formatDate($model->ed_date, "d M Y");             
            $list[$url] = $title;
        }
        
        //echo CHtml::dropDownList($this->name, [$current], $list,$this->htmlOptions);
        ?>
<style>
.scrollable-menu-btn{
    font-family:sans-serif;
}
.scrollable-menu {
    height: auto;
    max-height: 200px;
    overflow-x: hidden;
    
}
</style>
            <div class="btn-group">
                <button type="button" class="btn btn-danger dropdown-toggle scrollable-menu-btn <?= $this->class ?>" data-toggle="dropdown"><?= $currentDate ?> <span class="caret"></span></button>
                <ul class="dropdown-menu scrollable-menu" role="menu">
                    <?php foreach($list as $url => $title){ ?>
                    <li><a href="<?= $url ?>"><?= $title ?></a></li>
                    <?php } ?>
                </ul>
            </div>


        <script>
        $("select[name=<?= $this->name?>]").on("change",function(e){
            e.preventDefault();
            if($(this).val()!=="0"){
                window.location = $(this).val();
            }
        });
        </script>

<?php
    }
}