<?php
class CalenderWidget extends CWidget{
	const FORMAT_ONLYBUTTON = "a";
	const FORMAT_WITHTEXT = "b";
	
	public $id = "cal";
	
	public $format = self::FORMAT_ONLYBUTTON;	
	public $loadDefaultCSS = true;
	public $currentDate = "&nbsp;";
	public $catId = 0;
	public $highlightPastYears = 5;
	public $btnLabel = '<span class="glyphicon glyphicon-calendar"></span>';
	public $btnClass = 'btn btn-primary';
	public $btnStyle = '';
	
	public $txtClass = 'form-control';
	public $txtStyle = '';
	
	public function init(){
		parent::init();		
		if ($this->loadDefaultCSS) {
			$cs=Yii::app()->getClientScript();			
			$cs->registerCoreScript('jquery');                      
			$cs->registerCoreScript('jquery.ui');
			$cs->registerCssFile($cs->getCoreScriptUrl() . '/jui/css/base/jquery-ui.css');
		}
	}
	
	
	
	public function run(){
            
          //  Yii::app()->controller->widget("CalenderDropdown");
            //return;
            
            
		$id = $this->id;
		?>
		<style>
		.ui-datepicker{
	z-index:3 !important;
}
		</style>
<?php if($this->format==self::FORMAT_ONLYBUTTON){ ?>

<input
	style="width: 0px; height: 35px; border: none; background: transparent; visibility: hidden; border-color:transparent; display:hidden"
	type="text" id="datetext_<?php echo $id ?>"
	name="datetext_<?php echo $id ?>"
	value="<?php echo $this->currentDate; ?>" />

<a id="datebtn_<?php echo $id; ?>" style="<?php echo $this->btnStyle ?>" class="<?php echo $this->btnClass; ?>" href="#"><?php echo $this->btnLabel ?></a>

<?php } else { ?>

<div class="input-group <?php echo $id ?>_outer">
	<input style="<?php echo $this->txtStyle ?>" class="<?php echo $this->txtClass ?>" type="text" id="datetext_<?php echo $id ?>" name="datetext_<?php echo $id ?>" value="<?php echo $this->currentDate; ?>" />
	<span class="input-group-btn">
		<button id="datebtn_<?php echo $id; ?>" style="<?php echo $this->btnStyle ?>" class="<?php echo $this->btnClass; ?>" href="#"><?php echo $this->btnLabel ?></button>
	</span>
</div>

<?php } ?>

<?php
if(GlobalVar::i()->epaper_datelist===false){
    GlobalVar::i()->epaper_datelist = Yii::app()->db->createCommand()
        ->selectDistinct("ed_date")
        ->from("epaper_editions")
        ->where("ed_date > :then and ed_status = 'public'",array(":then"=>date("Y-m-d",strtotime('-'.$this->highlightPastYears.' years', time()))))
        ->queryColumn();
}
?>


<script>      
        var array = <?php echo json_encode(GlobalVar::i()->epaper_datelist); ?>;
         
        $(document).on("click","#datebtn_<?php echo $id; ?>",function(e){
            e.preventDefault();
            
            $("#datetext_<?php echo $id ?>").datepicker({
                dateFormat: "dd M yy",
                currentText: "<?php echo $this->currentDate; ?>",
                changeMonth: true,
                changeYear: true,    
                minDate: "-20Y",
                maxDate: "Y",   
                beforeShowDay: function(date){
                    var string = jQuery.datepicker.formatDate('yy-mm-dd', date);                        
                    var oldDate = new Date();                         
                    oldDate.setFullYear(oldDate.getFullYear()-<?php echo $this->highlightPastYears ?>);                                                  
                    var thisDate = new Date(string);

                    if(thisDate.getTime() <= oldDate.getTime()){
                        return [ true ];
                    } else {
                      return [ array.indexOf(string) > -1 ];
                    }
                },
                onSelect: function(dateText) {
                    var url = "<?php echo Yii::app()->createUrl("epaper/default/openarchive", array("archive" => "T_ARC", "cat_id" => "T_CAT")) ?>";
                    url = url.replace("T_ARC",dateText);
                    url = url.replace("T_CAT","<?php echo $this->catId ?>");
                    window.location = url;
                }
                });
            
            
            $("#datetext_<?php echo $id ?>").datepicker("show");
        });

</script>

<?php 	
	}
}