<?php

class CropWidget extends CWidget {

    public $pageModel;
    public $target;
    
    public function init() {
        parent::init();       
        $cs = Yii::app()->getClientScript();
        $cs->registerCoreScript('jquery');       
        $cs->registerCoreScript('jquery.ui');
        $cs->registerCssFile($cs->getCoreScriptUrl() . '/jui/css/base/jquery-ui.css');
        $cs->registerCssFile(AssetsManager::i()->getModuleAsset("epaper","jcrop/css/jquery.Jcrop.min.css"));
        $cs->registerScriptFile(AssetsManager::i()->getModuleAsset("epaper","jcrop/js/jquery.Jcrop.min.js"));
    }

    public function run() {

        $config = ModuleLoader::getConfig("epaper");
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];

        //$image_path = Yii::getPathOfAlias("webroot").$uploadDir.$mediaDir.$this->pageModel->pg_file;
        $image_url = Yii::app()->getBaseUrl(true) . $uploadDir . $mediaDir . $this->pageModel->pg_file;


        $thumb_url = ImageHelpers::i()->getThumbImage($image_url, 900);
        ?>
        <div id="cropCanvas">
            <div>
                <button name="btnProcess" id="btnProcess" class="btn btn-primary">Crop Image</button>
            </div>
            <img src="<?php echo $thumb_url ?>" />
        </div>
        <script>
            $(document).ready(function () {
                $("#cropCanvas").dialog({
                    "autoOpen": false,
                    "width": "auto",
                    "height": "auto"
                });
                $("#btnProcess").hide();
                var coords;
                
                $("#cropCanvas img").Jcrop({
                    "onSelect":function(c){
                        coords = c;
                        $("#btnProcess").show();
                    }
                });
                $("<?php echo $this->target ?>").on("click", function (e) {
                    e.preventDefault();
                    $("#cropCanvas").dialog("open");
                });
                $("#btnProcess").on("click",function(){
                    console.log(coords);
                });
            });
        </script>

        <?php
    }

}
