<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperFeed{
    public function addItems(CEvent $event){                
        $fc = $event->sender;        
        $cri = new CDbCriteria();
        $cri->limit = 10;
        $cri->condition = "ed_status = :ed_status AND ed_date > :unpublish_from";
        $cri->params = array(":ed_status"=>"public", ":unpublish_from"=>Helpers::i()->formatDate(EpaperSettings::i()->unpublish_from,"Y-m-d"));
        $cri->order = "ed_date DESC";
        $models = EpaperEdition::model()->findAll($cri);
        $epConfig = ModuleLoader::getConfig("epaper");
        if(count($models)>0){
            foreach($models as $model){
                $linkTag = "";
                $link = Yii::app()->createAbsoluteUrl("epaper/default/show",array("id"=>$model->ed_id,"alias"=>$model->ed_alias));
                if(trim($model->ed_image)!=""){
                    $baseUrl = Yii::app()->getBaseUrl(true);
                    $uploadDir = Yii::app()->params["uploadDir"];
                    $epaperDir = $epConfig["mediaDir"];
                    $file = $model->ed_image;
                    $imageUrl = ImageHelpers::i()->getThumbImage($baseUrl.$uploadDir.$epaperDir.$file, 250, 300, true);
                    $imageTag = CHtml::image($imageUrl,$model->ed_title);                    
                    $linkTag = CHtml::link($imageTag,$link)."<br />";
                }
                $fc->addItem($model->ed_title,
                        $linkTag.
                        $model->ed_desc,
                        $link,
                        strtotime($model->ed_date));
            }
        }
    } 
}