<?php

class EpaperHelpers extends AbstractSinglaton{
    public function getPdfLink($model){   
        $config = ModuleLoader::getConfig("epaper");
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];
        $baseDir = Yii::getPathOfAlias("webroot");    
        $baseUrl = Yii::app()->getBaseUrl(true);
        
        $id = Yii::app()->request->getParam("id");     
        
        if(get_class($model) == "EpaperEdition"){
            if($model->ed_status = "public"){
                if($model->ed_pdf!=""){                    
                    $file = $baseDir.$uploadDir.$mediaDir.$model->ed_pdf;
                    if(EpaperSettings::i()->pdf_download_mode == EpaperSettings::DOWNLOAD_MODE_PHP){

                        if(file_exists($file)){
                            return Yii::app()->createAbsoluteUrl("//epaper/default/downloadpdf",array("id"=>$model->ed_id,"type"=>"edition"));
                        }   
                    } else {
                        return $baseUrl.$uploadDir.$mediaDir.$model->ed_pdf;
                    }                
                }
            }
        } else if(get_class($model) == "EpaperPage"){
            if($model->pg_pdf!=""){                    
                $file = $baseDir.$uploadDir.$mediaDir.$model->pg_pdf;
                if(EpaperSettings::i()->pdf_download_mode == EpaperSettings::DOWNLOAD_MODE_PHP){
                    if(file_exists($file)){
                        return Yii::app()->createAbsoluteUrl("//epaper/default/downloadpdf",array("id"=>$model->pg_id,"type"=>"page"));
                    }   
                } else {
                    return $baseUrl.$uploadDir.$mediaDir.$model->pg_pdf;
                }                
            }
        }
        return "";
    }
}