<?php

class EpaperPageWidget extends CWidget{



  public $pageModel;

  public $areaClass = "area";

  public $canvasClass = "canvas";



  public $containerWidth = 800;



  public $imgclass = "thumbnail imagethumb";





  private $mapModels;



  public function init(){

    parent::init();

    $cs = Yii::app()->clientScript;

    //  $cs->registerScriptFile(AssetsManager::i()->getCoreAsset("js/maphighlight.js"));

    // $cs->registerScriptFile(AssetsManager::i()->getCoreAsset("js/maphighlight-large.js"));

    $cs->registerScriptFile(AssetsManager::i()->getCoreAsset("js/jquery.mapster.js"));

  }



  public function run(){

    $this->mapModels = $this->pageModel->getRelated("rMap",false,array("order"=>"mp_id DESC"));

    if(count($this->mapModels)>0){

      $this->displayMaps();

    } else {

      $this->displayImage();

    }

  }



  public function displayImage(){

    $config = ModuleLoader::getConfig("epaper");

    $uploadDir = Yii::app()->params["uploadDir"];

    $mediaDir = $config["mediaDir"];

    $baseUrl = Yii::app()->getBaseUrl(true);

    $imgurl = $baseUrl.$uploadDir.$mediaDir.$this->pageModel->pg_file;

    $thumburl = ImageHelpers::i()->getThumbImage($imgurl, $this->containerWidth);

    $imgtag = CHtml::image($thumburl);

    echo CHtml::link($imgtag,$imgurl,array("class"=>$this->imgclass,"target"=>"_blank"));

    ?>

    <style media="print">

    body *{

      display:none;

    }

    body #print_img{

      display:block !important;

    }

    </style>

    <?php

    echo  CHtml::image($thumburl,"",["class"=>'visible-print',"id"=>"print_img"]);

    ?>

    <script>

    if($(window).width() > 768){

      $('.imagethumb').colorbox();

    }

    $("body > #print_img").remove();

    $("body").prepend($("#print_img"));

    </script>

    <?php



  }

  public function displayMaps(){

    $config = ModuleLoader::getConfig("epaper");

    $uploadDir = Yii::app()->params["uploadDir"];

    $mediaDir = $config["mediaDir"];



    $image_path = Yii::getPathOfAlias("webroot").$uploadDir.$mediaDir.$this->pageModel->pg_file;

    $image_url = Yii::app()->getBaseUrl(true).$uploadDir.$mediaDir.$this->pageModel->pg_file;



    $wimg = WideImage::load($image_path);

    $image_width = $wimg->getWidth();

    $container_width = $this->containerWidth;

    $ratio = $image_width/$container_width;

    $thumb_url = ImageHelpers::i()->getThumbImage($image_url, $this->containerWidth);

    ?>



    <style>

    map[name=epapermap] + div{

      background-size:100% 100% !important;

    }

    .maphilighted{

      max-width: <?php echo $container_width; ?>px;

      /* display:block !important;*/

    }

    </style>



    <div class="<?php echo $this->canvasClass; ?>">

      <?php



      echo '<map name="epapermap">';

      foreach($this->mapModels as $m){

        $x1 = $m->mp_x/$ratio;

        $y1 = $m->mp_y/$ratio;

        $x2 = ($m->mp_x/$ratio)+($m->mp_w/$ratio);

        $y2 = ($m->mp_y/$ratio)+($m->mp_h/$ratio);



        echo "<area class='".$this->areaClass."' shape='rect' coords='$x1,$y1,$x2,$y2' href='#'

        data-x='".$m->mp_x."' data-y='".$m->mp_y."' data-h='".$m->mp_h."' data-w='".$m->mp_w."'

        data-id='".$m->mp_id."' data-alias='".$m->mp_alias."'

        alt=''>";

      }

      echo '</map>';

      ?>



      <img style="width:100%; height:auto;" id="mapimage" usemap="#epapermap" src="<?php echo $thumb_url; ?>" />



      <style media="print">

      body *{

        display:none;

      }

      body #print_img{

        display:block;

      }

      </style>



      <img id="print_img" class="visible-print" src="<?php echo $image_url; ?>" />



      <script>

      if($(window).width() <= 768){

        $("img[usemap]").mapster({

          stroke: true,

          strokeColor: "E32B25",

          strokeOpacity: 1,

          strokeWidth: 1,

          fillOpacity: 0.2,

          fade:false,

          configTimeout:100000,

          //staticState:true

        });

      } else {

        $("img[usemap]").mapster({

          stroke: true,

          strokeColor: "E32B25",

          strokeOpacity: 1,

          strokeWidth: 1,

          fillOpacity: 0.2,

          fade:false,

          configTimeout:100000,

          //staticState:true

        });

      }

      //$("img[usemap]").maphilight();



      $("body > #print_img").remove();

      $("body").prepend($("#print_img"));



      </script>

    </div>

    <?php if(EpaperPopupSettings::i()->enable_dialog == false){
        $url = Yii::app()->getBaseUrl(true);
      ?>

      <script>

      $(document).ready(function(){



        $(".area").on("click", function(e) {

          e.preventDefault();

          $('.area').mapster('deselect');

          var x = $(this).attr("data-x");

          var y = $(this).attr("data-y");

          var w = $(this).attr("data-w");

          var h = $(this).attr("data-h");



          var w2 = parseFloat(w) + parseFloat(<?php echo EpaperPopupSettings::i()->extra_width; ?>);

          var h2 = parseFloat(h) + parseFloat(<?php echo EpaperPopupSettings::i()->extra_height; ?>);



          if(w2<<?php echo EpaperPopupSettings::i()->minimum_width; ?>){

            w2 = <?php echo EpaperPopupSettings::i()->minimum_width; ?>;

          }



          if(h2<<?php echo EpaperPopupSettings::i()->minimum_height; ?>){

            h2 = <?php echo EpaperPopupSettings::i()->minimum_height; ?>;

          }



          var id = $(this).attr("data-id");

          var alias = $(this).attr("data-alias");



          var url = "<?php echo urldecode(Yii::app()->createUrl("//epaper/default/map",array("id"=>"[id]","alias"=>"[alias]"))); ?>"

          url = url.replace("[id]",id);

          url = url.replace("[alias]",alias);

          //alert(url + "hasan");




          var left = (screen.width/2)-(w/2);

          var top = (screen.height/2)-(h/2);

          if(w2 > screen.width){

            w2 = screen.width - 100;

          }

          if(h2 > screen.height){

            h2 = screen.height - 150;

          }



          h = parseInt(h) + 55;


          //console.log(url);

          $.ajax({
            url: url,
            type: 'get',
            data: {},
            success: function(response){
              $("#news-details-body-1").attr("src", response[0]);
              $("#news-details-body-2").attr("src", response[1]);
              $("#my-facebood-share").attr("href", "https://www.facebook.com/sharer/sharer.php?u=<?php echo $url ?>/epaper/share/" + id);
              $("#my-twitter-share").attr("href", "https://twitter.com/intent/tweet?url=<?php echo $url ?>/epaper/share/" + id);
              $("#my-print").attr("href", "<?php echo $url ?>/epaper/print/" + id);
              $('#myModalPopup').modal('toggle');
            }
          });

          //alert(url);
          //

          //window.open(url,"_blank",'width='+w2+',height='+h2+',toolbar=0,menubar=0,location=0,status=0,scrollbars=1,resizable=1,left='+left+',top='+top);

          return false;

        });

      });

      </script>



      <?php } else { ?>



        <style>

        .pdialog.ui-dialog .ui-dialog-content{

          padding:0px;

          overflow:hidden;

        }

        .pdialog.ui-dialog {

          box-shadow: 0px 0px 10px rgba(0,0,0,0.5);



          position:fixed;

        }

        </style>





        <div id="dialogWindow" title="<?php echo Yii::app()->controller->pageTitle ?>">

        <iframe style="width:100%; height:100%; border:none">

        </iframe>

        </div>



        <script>

        $(document).ready(function(){



          $("#dialogWindow").dialog({

            autoOpen:false, modal:true,dialogClass:"pdialog",

            height:<?php echo EpaperPopupSettings::i()->dialog_height ?>,

            close: function( event, ui ) {

              $("#dialogWindow iframe").attr("src","about:blank");

            },

            width:<?php echo EpaperPopupSettings::i()->dialog_width ?>,

          });

          $(".area").on("click", function(e) {

            e.preventDefault();



            if($(window).width() <= 768){

              //Open in New Window on Mobile Devices

              $('.area').mapster('deselect');



              var id = $(this).attr("data-id");

              var alias = $(this).attr("data-alias");



              var url = "<?php echo urldecode(Yii::app()->createUrl("//epaper/default/map",array("id"=>"[id]","alias"=>"[alias]"))); ?>"

              url = url.replace("[id]",id);

              url = url.replace("[alias]",alias);



              window.open(url,"_blank");

              return false;

            }





            $('.area').mapster('deselect');

            var id = $(this).attr("data-id");

            var alias = $(this).attr("data-alias");



            var url = "<?php echo urldecode(Yii::app()->createUrl("//epaper/default/map",array("id"=>"[id]","alias"=>"[alias]"))); ?>"

            url = url.replace("[id]",id);

            url = url.replace("[alias]",alias);



            $("#dialogWindow").dialog("open");

            $("#dialogWindow iframe").attr("src",url);



          });

        });

        </script>

        <?php }

      }

    }
