<?php
class EpaperPanPageWidget extends CWidget{
     public $pageModel;
 
     public $imgclass = "thumbnail";
    public function init(){
        $cs = Yii::app()->clientScript;
        $cs->registerScriptFile(AssetsManager::i()->getCoreAsset("js/jquery.panzoom.min.js"));
  
    }

    public function run(){
        $id = "p".uniqid();
        $config = ModuleLoader::getConfig("epaper");        
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];
        $baseUrl = Yii::app()->getBaseUrl(true);
        
        $imgurl = $baseUrl.$uploadDir.$mediaDir.$this->pageModel->pg_file;
        $imagepath = Yii::getPathOfAlias("webroot").$uploadDir.$mediaDir.$this->pageModel->pg_file;
        
        $wimg = WideImage::load($imagepath);
        $imagewidth = $wimg->getWidth(); 
                
        $imgtag = CHtml::image($imgurl,"",["id"=>$id,"style"=>"max-width:initial; width:100%"]); 
 
        echo "<div id='".$id."_container' class='".$this->imgclass."'>".$imgtag."</div>"
        //echo CHtml::link($imgtag,$imgurl,array("class"=>$this->imgclass));
 
                
        ?>
<style>
    #<?= $id ?>{
        position:relative;
    }
     
</style>
        <script>
            var $panzoom = $("#<?= $id ?>").panzoom({
                panOnlyWhenZoomed: true,
                contain:"invert"
            });  
            var zoom = "out";
            $( "#<?= $id ?>" ).dblclick(function(e) {
                e.preventDefault();
                var container_w = parseInt($("#<?= $id ?>_container").css("width"));
                var obj_w = <?= $imagewidth ?>;
                var ratio = obj_w/container_w;
                 
                if(zoom === "out"){
      
                    $panzoom.panzoom('zoom', ratio, {                        
                        focal: e
                    });  
                    zoom = "in";
                } else { 
                    $panzoom.panzoom("zoom",true);
                    $panzoom.panzoom("reset");
                    zoom = "out";
                }
            });
            
            
             
            
        </script>

        <style media="print">
        body *{
            display:none;
        }
        body #print_img{
            display:block !important; 
        }
        </style>
        <?= CHtml::image($imgurl,"",["class"=>'visible-print',"id"=>"print_img"]); ?>
        <script> 
            $("body").prepend($("#print_img"));
        </script>
        <?php
    }
}