<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperSitemap{
    public function addItems(CEvent $event){
        $fc = $event->sender;                
        
        if(EpaperSitemapSettings::i()->include_home){
            $priority = EpaperSitemapSettings::i()->pri_home;
            $frequency = EpaperSitemapSettings::i()->freq_home; 
            $link = Yii::app()->createAbsoluteUrl("epaper/default/index");                 
            $fc->addItem($link,$priority,$frequency);            
        }
        
        if(EpaperSitemapSettings::i()->include_editions){
            $cri = new CDbCriteria();
            $cri->limit = 10;
            $cri->condition = "ed_status = :ed_status AND ed_date > :unpublish_from";
            $cri->params = array(":ed_status"=>"public", ":unpublish_from"=>Helpers::i()->formatDate(EpaperSettings::i()->unpublish_from,"Y-m-d"));
            $cri->order = "ed_date DESC";
            $models = EpaperEdition::model()->findAll($cri);
            $priority = EpaperSitemapSettings::i()->pri_editions;
            $frequency = EpaperSitemapSettings::i()->freq_editions;        
            if(count($models)>0){
                foreach($models as $model){
                    $linkTag = "";
                    $link = Yii::app()->createAbsoluteUrl("epaper/default/show",array("id"=>$model->ed_id,"alias"=>$model->ed_alias));                 
                    $fc->addItem($link,$priority,$frequency);
                }
            } 
        }
        
        if(EpaperSitemapSettings::i()->include_categories){             
            $models = EpaperCategory::model()->findAll();
            $priority = EpaperSitemapSettings::i()->pri_categories;
            $frequency = EpaperSitemapSettings::i()->freq_categories;        
            if(count($models)>0){
                foreach($models as $model){
                    $linkTag = "";
                    $link = Yii::app()->createAbsoluteUrl("epaper/default/index",array("id"=>$model->cat_id,"alias"=>$model->cat_alias));                 
                    $fc->addItem($link,$priority,$frequency);
                }
            } 
        }
        
    }
}