<?php

class DefaultController extends PublicController {

    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        $this->breadcrumbs[Yii::t("epaper", "All Categories")] = $this->createUrl("//epaper/default/index");
        HeadComponent::i()->addTitle(EpaperSettings::i()->home_pagetitle);
        HeadComponent::i()->addMetaDescription(EpaperSettings::i()->home_metadesc);
        HeadComponent::i()->addMetaKeywords(EpaperSettings::i()->home_metakeys);
        if(trim(BasicSettings::i()->site_logo) != ""){
            HeadComponent::i()->setImage(Yii::app()->request->getBaseUrl(true)."/".BasicSettings::i()->site_logo);
        }
        $this->unpublish_from = Helpers::i()->formatDate(EpaperSettings::i()->unpublish_from,"Y-m-d");
    }
    public $unpublish_from;
    public function filters()
    {
        return array(
            array(
                'COutputCache - view, viewimage',
                'duration'=>  BasicSettings::i()->cache_duration,
                'varyByParam'=>array("id","alias","page","pg_id","search","spid","spalias"),
            ),
        );
    }

    public function actionHome() {
        unset($this->breadcrumbs[Yii::t("epaper", "All Categories")]);
        $edition_models = EpaperFeaturedEdition::model()->with("rEpaperEdition")->findAll(new CDbCriteria(array("order" => "fed_order ASC")));
        $category_models = EpaperFeaturedCategory::model()->with("rEpaperCategory")->findAll(new CDbCriteria(array("order" => "fcat_order ASC")));
        $this->render("home", array(
            "edition_models" => $edition_models,
            "category_models" => $category_models
        ));
    }

    //added from 2.1
    public function actionSingleHome(){
        $sModel = EpaperFeaturedEdition::model()->find(new CDbCriteria(array("order"=>"fed_order ASC")));
        if(is_null($sModel)){
            exit();
        }
        $page = 1; $perpage = 1;
        $edition = $sModel->getRelated("rEpaperEdition");
        $alias = $edition->ed_alias;
        $id = $edition->ed_id;
        $spid = Yii::app()->request->getParam("spid", 0);
        $spalias = Yii::app()->request->getParam("spalias", "xxx");

        //Check If Edition exists or not?
        $edition_model = EpaperEdition::model()->find("ed_id = :ed_id AND ed_status = :ed_status AND ed_date > :unpublish_from",
                array(":ed_id" => $id, ":ed_status" => "public", ":unpublish_from" => $this->unpublish_from
                    ));
        if (is_null($edition_model)) {
            throw new CHttpException(404, Yii::t("epaper", "Page not found"));
        }

        //If yes then check its alias
        if ($alias != $edition_model->ed_alias) {
            $url = $this->createUrl("//epaper/default/show", array("id" => $id, "alias" => $edition_model->ed_alias));
            $this->redirect($url, true, 301);
        }

        $supp_list = EpaperSupp::getSuppsFromEdition($edition_model->ed_id);

        $checkSuppList = function($spid) use($supp_list){
          /*
            foreach($supp_list as $sup){
                if($sup["sp_id"] == $spid){
                    return true;
                }
            }
            */
            return false;
        };

        $pg_models = EpaperPage::model()->findAll(
                    new CDbCriteria(array(
                    "condition" => "ed_id = :ed_id",
                    "params" => array(":ed_id"=>$edition_model->ed_id),
                    "order" => "pg_order ASC"
                    )));

        if(count($pg_models)==0){
            throw new CHttpException(404,Yii::t("epaper", "Pages are not present in this edition"));
        }



        $page_models = [];
        foreach($pg_models as $pgm){
            if($checkSuppList($pgm->sp_id)){
                $page_models[$pgm->sp_id][] = $pgm;
            } else {
                $page_models[0][] = $pgm;
            }
        }
        $mysubcat = EpaperSupp::model()->findAll();
        /*
		echo "<pre>";
		print_r($mysubcat);
		die();
    */

        if(!isset($page_models[$spid][$page-1])){
            throw new CHttpException(404,Yii::t("epaper", "Pages are not present in main section of this edition"));
        }

        $current_page_model = $page_models[$spid][$page-1];

        $cri = new CDbCriteria();
        $cri->limit = $perpage;
        $cri->offset = ($page * $perpage) - $perpage;
        $pagination = new CPagination(count($page_models[$spid]));
        $pagination->applyLimit($cri);
        $pagination->route = "//epaper/default/show";
        if($spid==0){
            $pagination->params = array(
                "id" => $id,
                "alias" => $alias
            );
        } else {
            $pagination->params = array(
                "id" => $id,
                "alias" => $alias,
                "spid" => $spid,
                "spalias" => $spalias
            );
        }
        $pagination->setPageSize($perpage);

        $this->genBreadcrumbs($edition_model->cat_id);

        $pagetitle = $edition_model->ed_title;
        if ($page > 1) {
            $pagetitle = $edition_model->ed_title . " " . Yii::t("epaper", "Page") . ": " . $page;
        }

        HeadComponent::i()->setMetaKeywords($edition_model->ed_metakeys);

        if (trim($edition_model->ed_metadesc) == "") {
            HeadComponent::i()->setMetaDescription($edition_model->ed_desc);
        } else {
            HeadComponent::i()->setMetaDescription($edition_model->ed_metadesc);
        }

        HeadComponent::i()->addMetaKeywords($current_page_model->pg_metakeys);
        if (trim($current_page_model->pg_metadesc) == "") {
            HeadComponent::i()->addMetaDescription($current_page_model->pg_desc);
        } else {
            HeadComponent::i()->addMetaDescription($current_page_model->pg_metadesc);
        }

        HeadComponent::i()->addTitle($pagetitle);

        GlobalVar::i()->currentDate = $edition_model->ed_date;

        $paramData = array(
            "id" => $id,
            "alias" => $alias,
            "page" => $page,
            "spid" => $spid,
            "spalias" => $spalias,
            "pagination" => $pagination,
            "page_models" => $page_models,
            "current_page_model" => $current_page_model,
            "edition_model" => $edition_model,
            "supp_list" => $supp_list,
            "pagetitle" => $pagetitle,
            "mysubcat" => $mysubcat,
        );

        if(Yii::app()->request->isAjaxRequest){
            $data["ajax1"] = $this->renderPartial("show_ajax1", $paramData,true);
            $data["ajax2"] = $this->renderPartial("show_ajax2", $paramData,true);
            $data["ajax3"] = $this->renderPartial("show_ajax3", $paramData,true);
            $data["page"] = $page;
            $data["alias"] = $alias;
            $data["spid"] = $spid;
            $data["spalias"] = $spalias;
            $data["id"] = $id;
            $data["alias"] = $alias;
            $data["page"] = $page;
            $data["title"] = HeadComponent::i()->generateTitle();
            $data["pagetitle"] = $pagetitle;
            AjaxOutput::i()->setData($data)->display();
        } else {
			$_SESSION['ed_date'] = $paramData['edition_model']['ed_date'];
            $this->render("show", $paramData);
        }
    }

    
    public function actionDownloadpdf(){
        $config = ModuleLoader::getConfig("epaper");
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];
        $baseDir = Yii::getPathOfAlias("webroot");

        if(EpaperSettings::i()->pdf_download_mode == EpaperSettings::DOWNLOAD_MODE_PHP){
            $id = Yii::app()->request->getParam("id");

            $type = Yii::app()->request->getParam("type","edition");
            if($type=="edition"){
                $model = EpaperEdition::model()->findByPk($id);
                if($model->ed_status == "public"){
                    if($model->ed_pdf!=""){
                        $file = $baseDir.$uploadDir.$mediaDir.$model->ed_pdf;
                        if(file_exists($file)){
                            Yii::app()->request->sendFile("epaper-".$model->ed_id.".pdf",file_get_contents($file),"application/octet-stream");
                        }
                    }
                }
            } else if($type=="page") {
                $model = EpaperPage::model()->findByPk($id);
                $edition = $model->getRelated("rEdition");
                if($edition->ed_status == "public"){
                    if($model->pg_pdf!=""){
                        $file = $baseDir.$uploadDir.$mediaDir.$model->pg_pdf;
                        if(file_exists($file)){
                            Yii::app()->request->sendFile("epaper-".$model->ed_id."-".$model->pg_id.".pdf",file_get_contents($file),"application/octet-stream");
                        }
                    }
                }
            }
        }
    }

    public function actionIndex() {




        //display category list
        $id = Yii::app()->request->getParam("id", 0);
        $alias = Yii::app()->request->getParam("alias", "");
        $archive = Yii::app()->request->getParam("archive","");
        $fArchiveDate = Helpers::i()->formatDate($archive, "d M, Y");

        $title = Yii::t("epaper", "Newest - All Categories");
        if($archive!=""){
            $title = Yii::t("epaper", "Archives")." - ".$fArchiveDate;
        }

        $category_model = EpaperCategory::model()->findByPk($id);

        if ($id > 0) {
            if (is_null($category_model)) {
                throw new CHttpException("404", Yii::t("epaper", "Page not found"));
            }
            if ($alias != $category_model->cat_alias) {
                $url = $this->createUrl("//epaper/default/index", array("id" => $id, "alias" => $category_model->cat_alias));
                $this->redirect($url, true, 301);
            }
            $title = Yii::t("epaper", "Newest") . " - " . $category_model->cat_title;
            if($archive!=""){
                $title = Yii::t("epaper", "Archives")." - ".$fArchiveDate." - ". $category_model->cat_title;
            }
            if (trim($category_model->cat_metadesc) != "") {
                HeadComponent::i()->setMetaDescription($category_model->cat_metadesc);
            } else {
                HeadComponent::i()->setMetaDescription($category_model->cat_desc);
            }

            HeadComponent::i()->setMetaKeywords($category_model->cat_metakeys);
        }
        $this->genBreadcrumbs($id);
        $page = Yii::app()->request->getParam("page", 1);

        $pageTitle = $h1Title = $title;
        if ($page > 1) {
            $pageTitle = $title . " - " . Yii::t("epaper", "Page") . " " . $page;
            $h1Title = $title . " - " . Yii::t("epaper", "Page") . " " . $page;
        }

        $subcategory_models = EpaperCategory::model()->findAll("cat_pid = :pid", array(":pid" => $id));

        $cri_param["condition"] = "ed_status = :ed_status AND ed_date > :unpublish_from";
        $cri_param["params"] = array(":ed_status" => "public",":unpublish_from"=>$this->unpublish_from);
        $cri_param["order"] = "ed_id DESC";
        if (EpaperSettings::i()->orderby == EpaperSettings::ORDERBY_DATE) {
            $cri_param["order"] = "ed_date DESC";
        }

        $cri = new CDbCriteria($cri_param);

        if ($id > 0) {
            $cri_param["condition"] = "t.cat_id = :cat_id AND ed_status = :ed_status AND ed_date > :unpublish_from";
            $cri_param["params"] = array(":cat_id" => $id, ":ed_status" => "public",":unpublish_from"=>$this->unpublish_from);
        }

        if($archive != ""){
            $cri_param["condition"] .= " AND ed_date = :ed_date ";
            $cri_param["params"][":ed_date"] = $archive;

        }

        $cri = new CDbCriteria($cri_param);

        $pagination = new CPagination(EpaperEdition::model()->count($cri));
        $pagination->pageSize =  EpaperSettings::i()->editions_perpage;
        $pagination->applyLimit($cri);
        $editon_models = EpaperEdition::model()->with("rCategory")->findAll($cri);

        HeadComponent::i()->addTitle($pageTitle);
		$_SESSION['ed_date'] = $edition_model['ed_date'];
        $this->render("index", array(
            "pagetitle" => $h1Title,
            "id" => $id,
            "category_model" => $category_model,
            "subcategory_models" => $subcategory_models,
            "edition_models" => $editon_models,
            "pagination" => $pagination));
    }



    public function actionIndex2() {

        //display category list
        $id = Yii::app()->request->getParam("id", 0);
        $alias = Yii::app()->request->getParam("alias", "");
        $archive = Yii::app()->request->getParam("archive","");
        $fArchiveDate = Helpers::i()->formatDate($archive, "d M, Y");

        $title = Yii::t("epaper", "Newest - All Categories");
        if($archive!=""){
            $title = Yii::t("epaper", "Archives")." - ".$fArchiveDate;
        }

        $category_model = EpaperCategory::model()->findByPk($id);

        if ($id > 0) {
            if (is_null($category_model)) {
                throw new CHttpException("404", Yii::t("epaper", "Page not found"));
            }
            if ($alias != $category_model->cat_alias) {
                $url = $this->createUrl("//epaper/default/index", array("id" => $id, "alias" => $category_model->cat_alias));
                $this->redirect($url, true, 301);
            }
            $title = Yii::t("epaper", "Newest") . " - " . $category_model->cat_title;
            if($archive!=""){
                $title = Yii::t("epaper", "Archives")." - ".$fArchiveDate." - ". $category_model->cat_title;
            }
            if (trim($category_model->cat_metadesc) != "") {
                HeadComponent::i()->setMetaDescription($category_model->cat_metadesc);
            } else {
                HeadComponent::i()->setMetaDescription($category_model->cat_desc);
            }

            HeadComponent::i()->setMetaKeywords($category_model->cat_metakeys);
        }
        $this->genBreadcrumbs($id);
        $page = Yii::app()->request->getParam("page", 1);

        $pageTitle = $h1Title = $title;
        if ($page > 1) {
            $pageTitle = $title . " - " . Yii::t("epaper", "Page") . " " . $page;
            $h1Title = $title . " - " . Yii::t("epaper", "Page") . " " . $page;
        }

        $subcategory_models = EpaperCategory::model()->findAll("cat_pid = :pid", array(":pid" => $id));

        $cri_param["condition"] = "ed_status = :ed_status AND ed_date > :unpublish_from";
        $cri_param["params"] = array(":ed_status" => "public",":unpublish_from"=>$this->unpublish_from);
        $cri_param["order"] = "ed_id DESC";
        if (EpaperSettings::i()->orderby == EpaperSettings::ORDERBY_DATE) {
            $cri_param["order"] = "ed_date DESC";
        }

        $cri = new CDbCriteria($cri_param);

        if ($id > 0) {
            $cri_param["condition"] = "t.cat_id = :cat_id AND ed_status = :ed_status AND ed_date > :unpublish_from";
            $cri_param["params"] = array(":cat_id" => $id, ":ed_status" => "public",":unpublish_from"=>$this->unpublish_from);
        }

        if($archive != ""){
            $cri_param["condition"] .= " AND ed_date = :ed_date ";
            $cri_param["params"][":ed_date"] = $archive;

        }

        $cri = new CDbCriteria($cri_param);

        $pagination = new CPagination(EpaperEdition::model()->count($cri));
        $pagination->pageSize =  EpaperSettings::i()->editions_perpage;
        $pagination->applyLimit($cri);
        $editon_models = EpaperEdition::model()->with("rCategory")->findAll($cri);

        HeadComponent::i()->addTitle($pageTitle);

        $this->render("index", array(
            "pagetitle" => $h1Title,
            "id" => $id,
            "category_model" => $category_model,
            "subcategory_models" => $subcategory_models,
            "edition_models" => $editon_models,
            "pagination" => $pagination));
    }

    public function actionDosearch(){
        $search = Yii::app()->request->getParam("search");
        $this->redirect($this->createUrl("search",array("search"=>$search)));
    }
    public function actionSearch(){

        if(EpaperSettings::i()->enable_search==false){
            $this->redirect(Yii::app()->getBaseUrl(true));
        }
        $search = Yii::app()->request->getParam("search");

        $ed_id = Yii::app()->request->getParam("ed_id",0);
        $edition_model = null;
        if($ed_id>0){
            $edition_model = EpaperEdition::model()->findByPk($ed_id);
            if(is_null($edition_model)){
                throw new CHttpException(404,"Edition not found");
            }
        }

        $page = Yii::app()->request->getParam("page",1);
        $limit = 18;
        $offset = ($page * $limit) - $limit;
        $data = EpaperMap::model()->doSearch($search,$ed_id,$limit,$offset);

        $pagination = new CPagination($data["total"]);
        $pagination->pageSize = $limit;
        $pagination->applyLimit(new CDbCriteria(array(
            "limit"=>$limit,"offset"=>$offset
        )));

        $pagetitle=  Yii::t("epaper", "Search Results")." - ".$search;
        if($ed_id > 0){
            $pagetitle=  Yii::t("epaper", "Search Results")." - ".$search." - ".$edition_model->ed_title;
        }

        HeadComponent::i()->addTitle($pagetitle);
        $this->render("search",array("data"=>$data,"pagination"=>$pagination,"pagetitle"=>$pagetitle,"edition_model"=>$edition_model));
    }

    public function actionOpenarchive(){

        $cat_id = Yii::app()->request->getParam("cat_id",0);
        $archive = Yii::app()->request->getParam("archive","");
        $date = Helpers::i()->formatDate($archive,"Y-m-d");

        if($cat_id == 0){
            $models = EpaperEdition::model()->with("rCategory")->findAll("ed_date = :ed_date",array(':ed_date'=>$date));
            if(count($models)==1){
                $m = $models[0];
                $url = $this->createUrl("show",array("id"=>$m->ed_id,"alias"=>$m->ed_alias));
            } else {
                $url = $this->createUrl("index",array("archive"=>$date));
            }
            $this->redirect($url);
        }


        $models = EpaperEdition::model()->with("rCategory")->findAll("ed_date = :ed_date AND t.cat_id = :cat_id",array(':ed_date'=>$date,":cat_id"=>$cat_id));
        if(count($models)>1){
            $m = $models[0];
            $url = $this->createUrl("index",array("id"=>$cat_id,"alias"=>$m->rCategory->cat_alias,"archive"=>$date));
            //redirect to archive with cat_id
        } else if(count($models)==1){
            $m = $models[0];
            $url = $this->createUrl("show",array("id"=>$m->ed_id,"alias"=>$m->ed_alias));
            //find id alias and redirect to show page
        } else {
            $url = $this->createUrl("index",array("archive"=>$date));
            //redirect to archive without cat_id
        }
        $this->redirect($url);
    }

    private function genBreadcrumbs($id) {
        $model = EpaperCategory::model()->findByPk($id);
        if (!is_null($model)) {
            $this->breadcrumbs[$model->cat_title] = $this->createUrl("//epaper/default/index", array("id" => $model->cat_id, "alias" => $model->cat_alias));
            $this->genBreadcrumbs($model->cat_pid);
        }
    }

    public function actionShow(){

        $page = Yii::app()->request->getParam("page", 1);
        $id = Yii::app()->request->getParam("id", 0);
        $alias = Yii::app()->request->getParam("alias", "");
        $spid = Yii::app()->request->getParam("spid", 0);
        $spalias = Yii::app()->request->getParam("spalias", "xxx");

        $perpage = 1;

        //Check If Edition exists or not?
        $edition_model = EpaperEdition::model()->find("ed_id = :ed_id AND ed_status = :ed_status AND ed_date > :unpublish_from",
                array(":ed_id" => $id, ":ed_status" => "public", ":unpublish_from" => $this->unpublish_from
                    ));
        if (is_null($edition_model)) {
            throw new CHttpException(404, Yii::t("epaper", "Page not found"));
        }

        //If yes then check its alias
        if ($alias != $edition_model->ed_alias) {
            $url = $this->createUrl("//epaper/default/show", array("id" => $id, "alias" => $edition_model->ed_alias));
            $this->redirect($url, true, 301);
        }

        $supp_list = EpaperSupp::getSuppsFromEdition($edition_model->ed_id);

        $checkSuppList = function($spid) use($supp_list){
          /*
            foreach($supp_list as $sup){
                if($sup["sp_id"] == $spid){
                    return true;
                }
            }
            */
            return false;
        };

        $pg_models = EpaperPage::model()->findAll(
                    new CDbCriteria(array(
                    "condition" => "ed_id = :ed_id",
                    "params" => array(":ed_id"=>$edition_model->ed_id),
                    "order" => "pg_order ASC"
                    )));



        if(count($pg_models)==0){
            throw new CHttpException(404,Yii::t("epaper", "Pages are not present in this edition"));
        }

        $page_models = [];
        foreach($pg_models as $pgm){
            if($checkSuppList($pgm->sp_id)){
                $page_models[$pgm->sp_id][] = $pgm;
            } else {
                $page_models[0][] = $pgm;
            }
        }

        if(!isset($page_models[$spid][$page-1])){
            throw new CHttpException(404,Yii::t("epaper", "Pages are not present in main section of this edition"));
        }

        $current_page_model = $page_models[$spid][$page-1];

        $cri = new CDbCriteria();
        $cri->limit = $perpage;
        $cri->offset = ($page * $perpage) - $perpage;
        $pagination = new CPagination(count($page_models[$spid]));
        $pagination->applyLimit($cri);
        $pagination->setPageSize($perpage);

        $this->genBreadcrumbs($edition_model->cat_id);

        $pagetitle = $edition_model->ed_title;
        if ($page > 1) {
            $pagetitle = $edition_model->ed_title . " " . Yii::t("epaper", "Page") . ": " . $page;
        }

        HeadComponent::i()->setMetaKeywords($edition_model->ed_metakeys);

        if (trim($edition_model->ed_metadesc) == "") {
            HeadComponent::i()->setMetaDescription($edition_model->ed_desc);
        } else {
            HeadComponent::i()->setMetaDescription($edition_model->ed_metadesc);
        }

        HeadComponent::i()->addMetaKeywords($current_page_model->pg_metakeys);
        if (trim($current_page_model->pg_metadesc) == "") {
            HeadComponent::i()->addMetaDescription($current_page_model->pg_desc);
        } else {
            HeadComponent::i()->addMetaDescription($current_page_model->pg_metadesc);
        }

        HeadComponent::i()->addTitle($pagetitle);

        GlobalVar::i()->currentDate = $edition_model->ed_date;
        $mysubcat = EpaperSupp::model()->findAll();
        $paramData = array(
            "id" => $id,
            "alias" => $alias,
            "page" => $page,
            "spid" => $spid,
            "spalias" => $spalias,
            "pagination" => $pagination,
            "page_models" => $page_models,
            "current_page_model" => $current_page_model,
            "edition_model" => $edition_model,
            "supp_list" => $supp_list,
            "pagetitle" => $pagetitle,
            "mysubcat" => $mysubcat
        );

        if(Yii::app()->request->isAjaxRequest){
            $data["ajax1"] = $this->renderPartial("show_ajax1", $paramData,true);
            $data["ajax2"] = $this->renderPartial("show_ajax2", $paramData,true);
            $data["ajax3"] = $this->renderPartial("show_ajax3", $paramData,true);
            $data["page"] = $page;
            $data["alias"] = $alias;
            $data["spid"] = $spid;
            $data["spalias"] = $spalias;
            $data["id"] = $id;
            $data["alias"] = $alias;
            $data["page"] = $page;
            $data["title"] = HeadComponent::i()->generateTitle();
            $data["pagetitle"] = $pagetitle;
            AjaxOutput::i()->setData($data)->display();
        } else {
		$_SESSION['ed_date'] = $paramData['edition_model']['ed_date'];
            $this->render("show", $paramData);
        }
    }

    public function _actionShow() {

        //display edition
        $page = Yii::app()->request->getParam("page", 1);
        $id = Yii::app()->request->getParam("id", 0);
        $alias = Yii::app()->request->getParam("alias", "");

        $spid = Yii::app()->request->getParam("spid", 0);
        $spalias = Yii::app()->request->getParam("spalias", "xxx");

        $perpage = 1;

        $edition_model = EpaperEdition::model()->find("ed_id = :ed_id AND ed_status = :ed_status AND ed_date > :unpublish_from",
                array(":ed_id" => $id, ":ed_status" => "public", ":unpublish_from" => $this->unpublish_from
                    ));
        if (is_null($edition_model)) {
            throw new CHttpException(404, Yii::t("epaper", "Page not found"));
        }

        if ($alias != $edition_model->ed_alias) {
            $url = $this->createUrl("//epaper/default/show", array("id" => $id, "alias" => $edition_model->ed_alias));
            $this->redirect($url, true, 301);
        }


        $supp_model = null;
        if($spid>0){
            $supp_model = EpaperSupp::model()->findByPk($spid);
            if(is_null($supp_model)){
                throw new CHttpException(404, Yii::t("epaper", "Page not found"));
            }
            if($spalias != $supp_model->sp_alias){
                $url = $this->createUrl("//epaper/default/show", array("id" => $id, "alias" => $edition_model->ed_alias, "spalias"=>$supp_model->sp_alias, "spid"=>$supp_model->sp_id));
                $this->redirect($url, true, 301);
            }
            HeadComponent::i()->addTitle($supp_model->sp_name);
        }

        $cri = new CDbCriteria();
        $cri->condition = "ed_id = :ed_id AND sp_id = :sp_id";
        $cri->params[":ed_id"] = $id;
        $cri->params[":sp_id"] = $spid;
        $cri->order = "pg_order ASC";
        $page_models = EpaperPage::model()->findAll($cri);

        $pagination = new CPagination(count($page_models));
        $pagination->applyLimit($cri);
        $pagination->setPageSize($perpage);

        $cri->limit = $perpage;
        $cri->offset = ($page * $perpage) - $perpage;
        $page_model = EpaperPage::model()->find($cri);

        if (is_null($page_model)) {
            throw new CHttpException(404, Yii::t("epaper", "Page not found"));
        }

        $this->genBreadcrumbs($edition_model->cat_id);

        $pagetitle = $edition_model->ed_title;
        if ($page > 1) {
            $pagetitle = $edition_model->ed_title . " " . Yii::t("epaper", "Page") . ": " . $page;
        }

        HeadComponent::i()->setMetaKeywords($edition_model->ed_metakeys);

        if (trim($edition_model->ed_metadesc) == "") {
            HeadComponent::i()->setMetaDescription($edition_model->ed_desc);
        } else {
            HeadComponent::i()->setMetaDescription($edition_model->ed_metadesc);
        }

        HeadComponent::i()->addMetaKeywords($page_model->pg_metakeys);
        if (trim($page_model->pg_metadesc) == "") {
            HeadComponent::i()->addMetaDescription($page_model->pg_desc);
        } else {
            HeadComponent::i()->addMetaDescription($page_model->pg_metadesc);
        }

        HeadComponent::i()->addTitle($pagetitle);

        $paramData = array(
            "id" => $id,
            "alias" => $alias,
            "page" => $page,
            "pagination" => $pagination,
            "page_models" => $page_models,
            "page_model" => $page_model,
            "edition_model" => $edition_model,
            "supp_model" => $supp_model,
            "pagetitle" => $pagetitle
        );

        if(Yii::app()->request->isAjaxRequest){
            $data["ajax1"] = $this->renderPartial("show_ajax1", $paramData,true);
            $data["ajax2"] = $this->renderPartial("show_ajax2", $paramData,true);
            $data["ajax3"] = $this->renderPartial("show_ajax3", $paramData,true);
            $data["page"] = $page;
            $data["alias"] = $alias;
            $data["title"] = HeadComponent::i()->generateTitle();
            $data["pagetitle"] = $pagetitle;
            AjaxOutput::i()->setData($data)->display();
        } else {
            $this->render("show", $paramData);
        }
    }


   public function actionMap(){
        $config = ModuleLoader::getConfig("epaper");
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];
        $baseUrl = Yii::app()->getBaseUrl(true);
        $id = Yii::app()->request->getParam("id");
        $alias = Yii::app()->request->getParam("alias");
        $this->layout = "//layouts/blank_template";

        $mapModel = EpaperMap::model()->findByPk($id);
        $pageModel =  $mapModel->getRelated("rPage");
        $editionModel = $pageModel->getRelated("rEdition");

        //Check if map is present or not
        if(is_null($mapModel)){
            throw new CHttpException(404,"Page not found");
        } else {
            if($alias != $mapModel->mp_alias){
                $this->redirect($this->createUrl("//epaper/default/map",array("id"=>$mapModel->mp_id,"alias"=>$mapModel->mp_alias)),true,301);
            }
        }

        //Check if respective edition is private or public
        if($editionModel->ed_status == "private"){
            throw new CHttpException(404,"Page Not found");
        }

        //find Previous and Next Maps;
        $previousMaps = EpaperMap::getPreviousMaps($mapModel);
        $previousMaps = array_reverse($previousMaps);
        $nextMaps = EpaperMap::getNextMaps($mapModel);

        //Creating Single Array of All Maps
        $mapsArray = [];
        $fillInArray = function($array) use (&$mapsArray){
            foreach($array as $r){
                $mapsArray[] = $r;
            }
        };
        $fillInArray($previousMaps);
        $fillInArray([$mapModel]);
        $fillInArray($nextMaps);


        //Setting SEO tags
        HeadComponent::i()->addTitle($editionModel->ed_title);
        HeadComponent::i()->addTitle($pageModel->pg_title);

        HeadComponent::i()->setMetaKeywords($editionModel->ed_metakeys);
        if (trim($editionModel->ed_metadesc) == "") {
            HeadComponent::i()->setMetaDescription($editionModel->ed_desc);
        } else {
            HeadComponent::i()->setMetaDescription($editionModel->ed_metadesc);
        }

        HeadComponent::i()->addMetaKeywords($pageModel->pg_metakeys);
        if (trim($pageModel->pg_metadesc) == "") {
            HeadComponent::i()->addMetaDescription($pageModel->pg_desc);
        } else {
            HeadComponent::i()->addMetaDescription($pageModel->pg_metadesc);
        }
        //First Map title will be actual title
        HeadComponent::i()->addMetaKeywords($mapsArray[0]->mp_metakeys);
        if (trim($mapsArray[0]->mp_metadesc) == "") {
            HeadComponent::i()->addMetaDescription($mapsArray[0]->mp_desc);
        } else {
            HeadComponent::i()->addMetaDescription($mapsArray[0]->mp_metadesc);
        }

        if(trim($mapsArray[0]->mp_title)!=""){
            HeadComponent::i()->addTitle($mapsArray[0]->mp_title);
        }

        //Creating Array of Images
        $ogImageArray = [];
        $imageArray = [];
        $descArray = [];
        foreach($mapsArray as $r){
            $imgUrl = $this->createAbsoluteUrl("viewmap",array("id"=>$r->mp_id));
            $ogImgUrl = $this->createAbsoluteUrl("viewmap",array("id"=>$r->mp_id,"resize"=>"yes"));
            if(trim($r->mp_image)!=""){
                $imgUrl = $baseUrl.$uploadDir.$mediaDir.$r->mp_image;
                $ogImgUrl = ImageHelpers::i()->getThumbImage($imgUrl, 200);
            }
            $ogImageArray[] = $ogImgUrl;
            $imageArray[] = $imgUrl;
            $descArray[] = $r->mp_desc;
        }

        HeadComponent::i()->setImage($ogImageArray[count($ogImageArray)-1]);


        $output = Yii::app()->request->getParam("output");
        if($output=="pdf"){
            $this->mapPDF(array(
            "editionModel"=>$editionModel,
            "pageModel"=>$pageModel,
            "mapModel"=>$mapModel,
            "mapsArray"=>$mapsArray,
            "imageArray"=>$imageArray,
            "descArray"=>$descArray,
            ));
        } else {
            $this->render("map",array(
                "editionModel"=>$editionModel,
                "pageModel"=>$pageModel,
                "mapModel"=>$mapModel,
                "mapsArray"=>$mapsArray,
                "imageArray"=>$imageArray,
                "descArray"=>$descArray,
            ));
        }
    }

    public function actionViewmap(){
        $mapid = Yii::app()->request->getParam("id");

        $mapModel = EpaperMap::model()->findByPk($mapid);
        if (is_null($mapModel)) {
            throw new CHttpException(404, "Page not found");
        }
        $id = $mapModel->pg_id;
        $x = $mapModel->mp_x;
        $y = $mapModel->mp_y;
        $w = $mapModel->mp_w;
        $h = $mapModel->mp_h;

        $cacheFile = $id . "-" . $x . $y . $w . $h.".jpg";
        $cacheDir = Yii::getPathOfAlias("application.runtime.epaper_imagecache") . "/";

        if (!file_exists($cacheDir)) {
            mkdir($cacheDir);
        }

        if (!file_exists($cacheDir . $cacheFile)) {

            $config = ModuleLoader::getConfig("epaper");
            $uploadDir = Yii::app()->params["uploadDir"];
            $mediaDir = $config["mediaDir"];

            $model = EpaperPage::model()->findByPk($id);
            if (is_null($model)) {
                throw new CHttpException(404, "Not found");
            }

            $image_path = Yii::getPathOfAlias("webroot") . $uploadDir . $mediaDir . $model->pg_file;

            $wimg = WideImage::load($image_path)->crop($x, $y, $w, $h);

            if(trim(EpaperAreaMapSettings::i()->image) == ""){
                $wimg->saveToFile($cacheDir . $cacheFile);
            } else {
                $watermark = WideImage::load(Yii::getPathOfAlias("webroot.uploads")."/".EpaperAreaMapSettings::i()->image);
                if($watermark->getWidth() > $wimg->getWidth()){
                    $watermark = $watermark->resize($wimg->getWidth());
                }
                if(EpaperAreaMapSettings::i()->merge_style == "nomerge"){
                    if(EpaperAreaMapSettings::i()->pos_v == "bottom"){
                        $wimg = $wimg->resizeCanvas($wimg->getWidth(), $wimg->getHeight()+$watermark->getHeight(), 0,0,$wimg->allocateColor(255,255,255));
                    } else if(EpaperAreaMapSettings::i()->pos_v == "top"){
                        $wimg = $wimg->resizeCanvas($wimg->getWidth(), $wimg->getHeight()+$watermark->getHeight(), 0,$watermark->getHeight(),$wimg->allocateColor(255,255,255));
                    }
                }
                $new = $wimg->merge($watermark, EpaperAreaMapSettings::i()->pos_h, EpaperAreaMapSettings::i()->pos_v, EpaperAreaMapSettings::i()->merge_opacity);

                $new->saveToFile($cacheDir . $cacheFile);
            }



        }

        $wimg = WideImage::load($cacheDir . $cacheFile);

        $resize = Yii::app()->request->getParam("resize","no");
        $width = Yii::app()->request->getParam("width",200);
        $height = Yii::app()->request->getParam("height",200);
        $crop = Yii::app()->request->getParam("crop","no");

        $data = file_get_contents($cacheDir . $cacheFile);
        $lastModifiedString = gmdate('D, d M Y H:i:s', filemtime($cacheDir . $cacheFile)) . ' GMT';
        $etag = md5($data);

//        header("Pragma: no-cache");
//        header('Etag: "'.$etag.'"');
//        header("Last-Modified: $lastModifiedString");
        //header("Content-Type: image/jpeg");
        if($resize=="yes"){
            if($crop=="yes"){
                $wimg->resize($width,$height,"outside")->crop("center","center",$width,$height)->output("jpg");
            } else {
                $wimg->resize($width,$height,"outside")->output("jpg");
            }
        } else{
            $wimg->output("jpg");
        }
    }
    /*
    public function actionView(){
        $this->layout = "//layouts/blank_template";

        $model = EpaperPage::model()->findByPk(Yii::app()->request->getParam("pg_id"));
        if(is_null($model)){
            throw new CHttpException(404,"Not found");
        }

        $edition_model = $model->getRelated("rEdition");

        if($edition_model->ed_status == "private"){
            throw new CHttpException(404,"Not found");
        }

        HeadComponent::i()->addTitle($edition_model->ed_title);
        HeadComponent::i()->addTitle($model->pg_title);


        HeadComponent::i()->setMetaKeywords($edition_model->ed_metakeys);

        if (trim($edition_model->ed_metadesc) == "") {
            HeadComponent::i()->setMetaDescription($edition_model->ed_desc);
        } else {
            HeadComponent::i()->setMetaDescription($edition_model->ed_metadesc);
        }

        HeadComponent::i()->addMetaKeywords($model->pg_metakeys);
        if (trim($model->pg_metadesc) == "") {
            HeadComponent::i()->addMetaDescription($model->pg_desc);
        } else {
            HeadComponent::i()->addMetaDescription($model->pg_metadesc);
        }

        $params["pg_id"] = Yii::app()->request->getParam("pg_id");
        $params["x"] = Yii::app()->request->getParam("x");
        $params["y"] = Yii::app()->request->getParam("y");
        $params["w"] = Yii::app()->request->getParam("w");
        $params["h"] = Yii::app()->request->getParam("h");
        $title = "";
        if(trim($model->pg_cdata)!=""){
            $cdata = unserialize($model->pg_cdata);

            foreach($cdata["area"] as $c){
                if( (string)$c["x"]==(string)$params["x"]
                    &&
                    (string)$c["y"]==(string)$params["y"]
                    &&
                    (string)$c["w"]==(string)$params["w"]
                    &&
                    (string)$c["h"]==(string)$params["h"] ){
                    if(isset($c["title"])){
                        if(trim($c["title"])!=""){
                            $title = $c["title"];
                            HeadComponent::i()->addTitle($c["title"]);
                        }
                    }
                }
            }
        }

        $url = $this->createUrl("viewimage",$params);

        $this->render("view",array("url"=>$url,"edition_model"=>$edition_model,"title"=>$title));
    }

    public function actionViewimage(){
        $id = Yii::app()->request->getParam("pg_id");
        $x = Yii::app()->request->getParam("x");
        $y = Yii::app()->request->getParam("y");
        $w = Yii::app()->request->getParam("w");
        $h = Yii::app()->request->getParam("h");

        $cacheFile = $id."-".$x.$y.$w.$h;
        $cacheDir = Yii::getPathOfAlias("application.runtime.epaper_imagecache")."/";

        if(!file_exists($cacheDir)){
            mkdir($cacheDir);
        }

        if(!file_exists($cacheDir.$cacheFile)){
            $config = ModuleLoader::getConfig("epaper");
            $uploadDir = Yii::app()->params["uploadDir"];
            $mediaDir = $config["mediaDir"];

            $model = EpaperPage::model()->findByPk($id);
            if(is_null($model)){
                throw new CHttpException(404,"Not found");
            }

            $image_path = Yii::getPathOfAlias("webroot").$uploadDir.$mediaDir.$model->pg_file;

            $wimg = WideImage::load($image_path);
            $wimg->crop($x, $y, $w, $h)->saveToFile($cacheDir.$cacheFile.".jpg");
        }

        $wimg = WideImage::load($cacheDir.$cacheFile.".jpg");
        $wimg->output("jpg");

    }
     */
    public function actionCategorylatest(){
        $id = Yii::app()->request->getParam("id");
        $editionModel = EpaperEdition::model()->find(new CDbCriteria([
            "condition"=>"cat_id = :cat_id","params"=>[":cat_id"=>$id],
            "order"=>"ed_date desc","limit"=>1]));
        if(!is_null($editionModel)){
            $this->redirect($this->createUrl("show",["id"=>$editionModel->ed_id,"alias"=>$editionModel->ed_alias]), true, 301);
        } else {
            throw new Exception("Edition not found", 404);
        }
    }
}
