<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class BookmarkController extends AdminController{
    public function actionIndex(){        
        $id = Yii::app()->request->getParam("id");
        $editionModel = EpaperEdition::model()->findByPk($id);
        if(!is_null($editionModel)){
            $this->pageTitle = $editionModel->ed_title." - Manage Bookmarks";
            $this->render("index",array("model"=>new EpaperBookmark(),"id"=>$id));
        }
    }
    public function actionLoadlist(){
        $id = Yii::app()->request->getParam("ed_id");
        $bookmarkModels = EpaperBookmark::model()->findAll("ed_id = :ed_id ORDER BY bkm_order ASC", array(":ed_id"=>$id));
        $bookmarkHtml = $this->renderPartial("loadlist_bookmark", array("models"=>$bookmarkModels), true);
   
        $pageModels = EpaperPage::model()->findAll("ed_id = :ed_id", array(":ed_id"=>$id));
      
        $pageHtml = $this->renderPartial("loadlist_page", array("models"=>$pageModels), true);
        AjaxOutput::i()->setData(array(
            "bookmarkHtml"=>$bookmarkHtml,
            "pageHtml" => $pageHtml
        ))->display();
    }
    public function actionReorder(){
        $i = 1;
        foreach ($_POST['item'] as $id) {
            EpaperBookmark::model()->updateByPk($id, array("bkm_order"=>$i),"ed_id = :ed_id",array(":ed_id"=>Yii::app()->request->getParam("ed_id")));            
            $i++;
        }
        AjaxOutput::i()->display();
    }
    public function actionAdd(){
        $order = Yii::app()->db->createCommand("SELECT MAX(bkm_order) FROM epaper_bookmarks WHERE ed_id = :ed_id")
                ->execute(array(":ed_id"=>Yii::app()->request->getParam("ed_id")));        
        $model = new EpaperBookmark();
        $model->bkm_title = Yii::app()->request->getParam("title");
        $model->ed_id = Yii::app()->request->getParam("ed_id");
        $model->pg_id = Yii::app()->request->getParam("pg_id");
        $model->bkm_order = $order+1;
        if($model->validate()){            
            $model->save();
            AjaxOutput::i()->setStatus(true);
        }
        AjaxOutput::i()->display();
    }
    public function actionDelete(){
       $id = Yii::app()->request->getParam("id"); 
       $model = EpaperBookmark::model()->findByPk($id);       
       if(!is_null($model)){
           $sql = "UPDATE epaper_bookmarks SET bkm_order = bkm_order-1 WHERE ed_id = :ed_id AND bkm_order>:order";
           Yii::app()->db->createCommand($sql)->execute(array(":ed_id"=>$model->ed_id,":order"=>$model->bkm_order));
           $model->delete();
       }
       AjaxOutput::i()->setStatus(true)->display();
    }
}