<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class CategoryController extends AdminController{
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("ep_manage_categories");
    }


    public function actionIndex(){
        $this->pageTitle = "Category Manager";
        $formModel = new EpaperCategoryForm();
        $formModel->cat_pid = 0;
        $this->render("index",array("formModel"=>$formModel));
    }
    public function actionLoadlist(){
        $records = EpaperCategory::model()->processCategoryHierarchy();
        $this->renderPartial("loadlist",array("records"=>$records,"level"=>0));
    }
    public function actionGet(){
        $id = Yii::app()->request->getParam("id");
        $model = EpaperCategory::model()->findByPk($id);        
        if(!is_null($model)){
            AjaxOutput::i()->setStatus(true)->setData($model)->display();
        }
        AjaxOutput::i()->setStatus(false)->display();            
    }
    public function actionLoadcategorylist(){
        $id = Yii::app()->request->getParam("id",0);
        $categories = EpaperCategory::model()->getFullHierarchyAsPlainArray($id,true);
        
        $str = "";
          
        foreach($categories as $k=>$v){
            $str .= "<option value='".$k."'>".$v."</option>";
        }
        echo $str;
    }
    public function actionSave(){ 
        $params = Yii::app()->request->getParam("EpaperCategoryForm");
        $form = new EpaperCategoryForm();
        $form->attributes = $params;
        $form->imagefile = CUploadedFile::getInstance($form, "imagefile");
        $form->cat_id = $_POST["EpaperCategoryForm"]["cat_id"];        
        if($form->validate()){
            $form->save();
            EpaperCategory::model()->processCategoryHierarchy();
            AjaxOutput::i()->setStatus(true)->display();
        }
        AjaxOutput::i()
                ->setStatus(false)
                ->setValidationStatus(false)
                ->setValidationErrors($form->getErrors())
                ->display();        
    }
     
    public function actionDelete(){
       $id = Yii::app()->request->getParam("id");
       if($id==1){
           AjaxOutput::i()->setError("This category can not be deleted")->display();
       }
       
       $form = new EpaperCategoryForm();
       $form->delete($id);
       AjaxOutput::i()->setStatus(true)->display();
    }
    
    
    
    
    public function actionSendfront(){
        $id = Yii::app()->request->getParam("id");
        EpaperFeaturedCategory::model()->add($id);
        AjaxOutput::i()->setStatus(true)->display();
    }
    public function actionRemovefront(){
        $id = Yii::app()->request->getParam("id");
        EpaperFeaturedCategory::model()->remove($id);
        AjaxOutput::i()->setStatus(true)->display();
    }
    public function actionFeatured(){
        $this->pageTitle = "Featured Categories";
        $this->render("featured");
    }
    public function actionFeatured_saveorder(){
        $i = 1;
       
        foreach ($_POST['item'] as $fcat_id) {
            EpaperFeaturedCategory::model()->updateByPk($fcat_id, array("fcat_order"=>$i));            
            $i++;
        }
        AjaxOutput::i()->display();
    }
    public function actionFeatured_loadlist(){
        $cri = new CDbCriteria();
        $cri->order = "fcat_order ASC";
        
        $models = EpaperFeaturedCategory::model()->with("rEpaperCategory")->findAll($cri);
        $data = $this->renderPartial("featured_loadlist",array("models"=>$models),true);
        AjaxOutput::i()->setData($data)->display();
    }
    public function actionSuggest(){
        $search = Yii::app()->request->getParam("term");
        $suggest = array();
      
        $cri = new CDbCriteria( array(
                        'condition' => "cat_title LIKE :search",
                        'params'    => array(':search' => "%$search%"),
                        'limit' => 20,
                        'order' => "cat_title asc"
        ));
        $result = EpaperCategory::model()->findAll($cri);
        if(count($result)>0){
                foreach($result as $r){
                        $suggest[] = array("id"=>$r->cat_id,"label"=>$r->cat_title,"value"=>$r->cat_title);
                }
        }
        echo json_encode($suggest);
    }
    
    public function actionSupplist(){
        $cat_id = Yii::app()->request->getParam("id");
        $models = EpaperSupp::model()->findAll("cat_id = :cat_id ORDER BY sp_order ASC", array(":cat_id"=>$cat_id));
        $this->renderPartial("supplist",array("models"=>$models));
    }
    public function actionSuppsave(){
        $p = Yii::app()->request->getParam("EpaperSupp");
        $model = new EpaperSupp();
        $model->sp_order = 1;
        if($p["sp_id"]>0){
            $model = EpaperSupp::model()->findByPk($p["sp_id"]);
            $old_cat_id = $model->cat_id;
        }  
        $model->setAttributes($p);
        $model->sp_alias = Helpers::i()->getAlias($p["sp_name"], $p["sp_alias"]);
        if($model->validate()){
            if($model->isNewRecord){
                $sql = "UPDATE epaper_supps SET sp_order = sp_order + 1 WHERE cat_id = :cat_id";
                Yii::app()->db->createCommand($sql)->execute(array(":cat_id"=>$p["cat_id"]));
            } else {
                if($old_cat_id != $p["cat_id"]){                    
                    Yii::app()->db->createCommand("UPDATE epaper_supps SET sp_order = sp_order-1 WHERE sp_order > :sp_order AND cat_id = :cat_id")
                        ->execute(array(":sp_order"=>$model->sp_order,":cat_id"=>$old_cat_id));
                    //now change the order
                    $model->sp_order = 1;
                    $sql = "UPDATE epaper_supps SET sp_order = sp_order + 1 WHERE cat_id = :cat_id";                     
                    Yii::app()->db->createCommand($sql)->execute(array(":cat_id"=>$p["cat_id"]));
                }
            }
            $model->save();
            AjaxOutput::i()->setStatus(true);
        }
        AjaxOutput::i()->display();
    }
    public function actionSuppget(){
       $id = Yii::app()->request->getParam("id");
       
       $model = EpaperSupp::model()->findByPk($id);
       if(!is_null($model)){           
            AjaxOutput::i()->setData($model)->setStatus(true);
       }
       AjaxOutput::i()->display();
    }
    public function actionSuppdelete(){
        $id = Yii::app()->request->getParam("id");
        $remove = Yii::app()->request->getParam("remove","");
         
        $model = EpaperSupp::model()->findByPk($id);
        if(!is_null($model)){            
            Yii::app()->db->createCommand("UPDATE epaper_supps SET sp_order = sp_order-1 WHERE sp_order > :sp_order AND cat_id = :cat_id")
                    ->execute(array(":sp_order"=>$model->sp_order,":cat_id"=>$model->cat_id));               
            if($remove=="remove"){
                $models= EpaperPage::model()->findAll("sp_id = :sp_id",array(":sp_id"=>$model->sp_id));
                foreach($models as $m){
                    $m->deletePage($m->pg_id);
                }
                
            } else {
                Yii::app()->db->createCommand("UPDATE epaper_pages SET sp_id = 0 WHERE sp_id = :sp_id")->execute(array(":sp_id"=>$id));                
            }
          
            $model->delete();
            
            AjaxOutput::i()->setStatus(true);
        }
        AjaxOutput::i()->display();
    }
    public function actionSuppreorder(){
        $i = 1;
        foreach ($_POST['item'] as $sp_id) {
            EpaperSupp::model()->updateByPk($sp_id, array("sp_order"=>$i),"cat_id = :cat_id",array(":cat_id"=>Yii::app()->request->getParam("cat_id")));            
            $i++;
        }
        AjaxOutput::i()->display();
    }
}