<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EditionController extends AdminController{
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("ep_manage_editions");
    }

    
    public function actionIndex(){
        $this->pageTitle = "Edition Manager";
        $formModel = new EpaperEditionForm();        
        $this->render("index",array("formModel"=>$formModel));
    }
    
    public function actionLoadlist(){
        $search = Yii::app()->request->getParam("search", "");
        $cat_id = Yii::app()->request->getParam("cat_id", 0);
        
        $page = Yii::app()->request->getParam("page", 1);
        $limit = 15;
        $offset = ($page * $limit) - $limit;

        $data = EpaperEdition::model()->loadList($search,$cat_id,$limit,$offset);

        AjaxOutput::i()->setStatus(true);
        AjaxOutput::i()->setData($data);
        AjaxOutput::i()->display();
    }
    public function actionGet(){
         $id = Yii::app()->request->getParam("id");
        $model = EpaperEdition::model()->findByPk($id);        
        if(!is_null($model)){
            $model->ed_date = date("d M Y",strtotime($model->ed_date));
            AjaxOutput::i()->setStatus(true)->setData($model)->display();
        }
        AjaxOutput::i()->setStatus(false)->display();  
    }
    public function actionSave(){
        
        $params = Yii::app()->request->getParam("EpaperEditionForm");
        $form = new EpaperEditionForm();
        $form->attributes = $params;
        $form->imagefile = CUploadedFile::getInstance($form, "imagefile");
        $form->pdffile = CUploadedFile::getInstance($form, "pdffile");
        $form->ed_id = $params["ed_id"];        
        if($form->validate()){
            $form->save();            
            AjaxOutput::i()->setStatus(true)->display();
        }
        AjaxOutput::i()
                ->setStatus(false)
                ->setValidationStatus(false)
                ->setValidationErrors($form->getErrors())
                ->display();
    }
    public function actionDelete(){
       $id = Yii::app()->request->getParam("id");        
       $form = new EpaperEditionForm();
       $form->delete($id);
       AjaxOutput::i()->setStatus(true)->display();
    }
    public function actionSendfront(){
        $ed_id = Yii::app()->request->getParam("id");
        EpaperFeaturedEdition::model()->add($ed_id);
        AjaxOutput::i()->setStatus(true)->display();
    }
    public function actionRemovefront(){
        $ed_id = Yii::app()->request->getParam("id");
        EpaperFeaturedEdition::model()->remove($ed_id);
        AjaxOutput::i()->setStatus(true)->display();
    }
    public function actionFeatured(){
        $this->pageTitle = "Featured Editions";
        $this->render("featured");
    }
    public function actionFeatured_saveorder(){
        $i = 1;
       
        foreach ($_POST['item'] as $fed_id) {
            EpaperFeaturedEdition::model()->updateByPk($fed_id, array("fed_order"=>$i));            
            $i++;
        }
        AjaxOutput::i()->display();
    }
    public function actionFeatured_loadlist(){
        $cri = new CDbCriteria();
        $cri->order = "fed_order ASC";
        
        $models = EpaperFeaturedEdition::model()->with("rEpaperEdition")->findAll($cri);
        $data = $this->renderPartial("featured_loadlist",array("models"=>$models),true);
        AjaxOutput::i()->setData($data)->display();
    }
    public function actionSuggest(){
        $search = Yii::app()->request->getParam("term");
        $suggest = array();
      
        $cri = new CDbCriteria( array(
                        'condition' => "ed_title LIKE :search",
                        'params'    => array(':search' => "%$search%"),
                        'limit' => 20,
                        'order' => "ed_title asc"
        ));
        $result = EpaperEdition::model()->findAll($cri);
        if(count($result)>0){
                foreach($result as $r){
                        $suggest[] = array("id"=>$r->ed_id,"label"=>$r->ed_title,"value"=>$r->ed_title);
                }
        }
        echo json_encode($suggest);
    }
}