<?php

class MapController extends AdminController{
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("ep_manage_editions");
    }
    public function actionIndex(){
        $id = Yii::app()->request->getParam("id");
        $model = EpaperPage::model()->with("rEdition")->findByPk($id);
        if(is_null($model)){
            throw new CHttpException(404,"Not found");
        }
        $mapModels = EpaperMap::model()->findAll("pg_id = :pg_id",array(":pg_id"=>$id));
        
        $this->pageTitle = "Editor - ".$model->pg_title." - ".$model->rEdition->ed_title;        
        $this->render("index",array("model"=>$model,"mapModels"=>$mapModels,"formModel"=>new EpaperMapForm()));
    }
    public function actionSavemap(){
        $mapid = Yii::app()->request->getParam("mapid");
        $pg_id = Yii::app()->request->getParam("pg_id");
        $x = number_format(Yii::app()->request->getParam("x"),4,".","");
        $y = number_format(Yii::app()->request->getParam("y"),4,".","");
        $w = number_format(Yii::app()->request->getParam("w"),4,".","");
        $h = number_format(Yii::app()->request->getParam("h"),4,".","");
        $ratio = number_format(Yii::app()->request->getParam("ratio"),4,".","");
        
        $model = EpaperMap::model()->findByPk($mapid);
        if(is_null($model)){
            $model = new EpaperMap();
            $model->mp_alias = uniqid();
            $model->mp_title = "";
            $model->mp_desc = "";
            $model->mp_metadesc = "";
            $model->mp_metakeys = "";
            $model->mp_image = "";
        }
        $model->mp_x = $x*$ratio;
        $model->mp_y = $y*$ratio;
        $model->mp_w = $w*$ratio;
        $model->mp_h = $h*$ratio;
        $model->mp_ratio = $ratio;
        $model->pg_id = $pg_id;
	 
		if($model->validate()){
			$model->save();
                        
                        
                        
			AjaxOutput::i()->setData(array(
                            "id"=>$model->mp_id,
                            
                                ))->display();
		} else {
                    //update
			AjaxOutput::i()->setValidationStatus(false)->setValidationErrors($model->getErrors())->display();
		}
        
    }
    public function actionGet(){
        $mapid = Yii::app()->request->getParam("mapid");    
        $model = EpaperMap::model()->findByPk($mapid);        
        if(!is_null($model)){            
            $data["title"] = $model->mp_title;
            $data["alias"] = $model->mp_alias;
            $data["description"] = $model->mp_desc;
            $data["metakeys"] = $model->mp_metakeys;
            $data["metadesc"] = $model->mp_metadesc;
            $data["image"] = $model->mp_image;            
            $data["map_id"] = $model->mp_id;
            $data["next_link_id"] = $model->mp_next_link;
             
            
            AjaxOutput::i()->setData($data)->setStatus(true);
        }         
        AjaxOutput::i()->display();
    }
    public function actionSave(){
        $form = new EpaperMapForm();
        $form->setAttributes(Yii::app()->request->getParam("EpaperMapForm"));
        $form->file = CUploadedFile::getInstance($form, "file");
        if($form->validate()){
            $form->save();
            AjaxOutput::i()->setStatus(true);
        } else {            
            AjaxOutput::i()->setValidationStatus(false)->setValidationErrors($form->getErrors());
        }
        AjaxOutput::i()->display();
    }
    public function actionDelete(){
        $mapid = Yii::app()->request->getParam("mapid");
        (new EpaperMapForm())->delete($mapid);
        AjaxOutput::i()->display();
    }
}