<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class PageController extends AdminController{
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("ep_manage_editions");
    }
    public function actionIndex(){
        $ed_id = Yii::app()->request->getParam("ed_id");
        $model = EpaperEdition::model()->findByPk($ed_id);
        if(!is_null($model)){
            
            
            $this->pageTitle = $model->ed_title." - ".Helpers::i()->formatDate($model->ed_date,"d M Y")." - (Add/Edit Pages)";
            $formModel = new EpaperPageForm();
            
            if($_SERVER["REQUEST_METHOD"]=="POST"){
                $files = CUploadedFile::getInstancesByName("file");
		
		foreach($files as $file){
			$title = null;
			if(count($files)>1){
				$title = $file->getName();
				$title = explode(".",$title);
				$title = $title[0];
			}
		        if(strtolower($file->getExtensionName()) !== "pdf"){
		            Yii::app()->user->setFlash("error","This file is not pdf.".$file->getName());
		        } else {
                            
                            $result = $this->uploadPdf($ed_id,Yii::app()->request->getParam("sp_id",0),
							Yii::app()->request->getParam("zoom",100),
							Yii::app()->request->getParam("compression",80),
							Yii::app()->request->getParam("from"),Yii::app()->request->getParam("to"),
							$file->getTempName());
                              
		            if(!$result){
		                Yii::app()->user->setFlash("error","Error while uploading file.");
		            }
		        }
		}
            }
            
            $this->render("index",array("formModel"=>$formModel));
        }
    }
    public function actionSaveorder(){
        $i = 1;
        foreach ($_POST['item'] as $pg_id) {
            EpaperPage::model()->updateByPk($pg_id, array("pg_order"=>$i),"ed_id = :ed_id",array(":ed_id"=>Yii::app()->request->getParam("ed_id")));            
            $i++;
        }
        AjaxOutput::i()->display();
    }
    public function actionLoadlist(){
        $cri = new CDbCriteria();
        $cri->order = " pg_order ASC ";
        $cri->condition = " ed_id = :ed_id ";
        $cri->params[":ed_id"] = Yii::app()->request->getParam("ed_id",0);
        $models = EpaperPage::model()->with("rSupp")->findAll($cri);
        $data = $this->renderPartial("loadlist",array("models"=>$models),true);
        AjaxOutput::i()->setData($data)->display();        
    }
    
    public function uploadPdf($ed_id,$sp_id,$zoom,$compression=80,$from,$to,$pdffile){                 
	if(!EpaperSettings::i()->enable_pdf2jpg){
            throw new CException("Please enable PDF to JPG Converter from Epaper Settings first.");
        }
        $newfile = Yii::getPathOfAlias("application.runtime.cache")."/".uniqid().".pdf";
        move_uploaded_file($pdffile, $newfile);
        
        $page = $to;
        for ($x = $from;$x <= $to; $x++) { 
            
            $config = ModuleLoader::getConfig("epaper");                
            $folder = $config["mediaDir"];            
            $baseDir = Yii::getPathOfAlias("webroot");
            $uploadDir = Yii::app()->params["uploadDir"];            
            $monthDir = date("Y-m")."/";

            if(!file_exists($baseDir.$uploadDir)){
                mkdir($baseDir.$uploadDir);                   
            }
            if(!file_exists($baseDir.$uploadDir.$folder)){
                mkdir($baseDir.$uploadDir.$folder);
            }
            if(!file_exists($baseDir.$uploadDir.$folder.$monthDir)){
                mkdir($baseDir.$uploadDir.$folder.$monthDir);
            }

            $filename = $monthDir.uniqid().".jpg";       
	  
            $pdffile = $pdffile;
            $targetfile = $baseDir.$uploadDir.$folder.$filename;
            
            $p = $page-1;
            
            $param1 = "";
            if(isset($_POST["antialias"])){
                $param1 = "+antialias";
            }
            
            $param2 = "";
            if(isset($_POST["alpha"])){
                $param2 = "-alpha flatten";
            }
            
          
            if(isset($_POST["sup_sample"])){
                $command = 'convert -density '.($zoom*4).' '.$newfile.'['.$p.'] -quality '.$compression.' '.$param1.' -resize 25% '.$param2.' '.$targetfile;
            } else {            
                $command = 'convert -density '.$zoom.' '.$newfile.'['.$p.'] -quality '.$compression.' '.$param1.' '.$param2.' '.$targetfile;
            }
 
            exec($command);  
            
            $model = new EpaperPage();
            $model->pg_title=  "Page ".$page;	  
            $model->pg_metadesc = "";
            $model->pg_metakeys = "";
            $model->pg_desc = "";
            $model->ed_id = $ed_id;
            $model->sp_id = $sp_id;
            $model->pg_order = $model->getMaxOrder($ed_id) + 1;  
            $model->pg_file = $filename;
            $model->pg_cdata = "";
            if($model->validate()){
                $model->save();
            }
            $page--;
        }
        
        if(file_exists($newfile)){
            unlink($newfile);
        }
        return true;
    }
    
    
    
    public function actionUpload(){
        $mode = Yii::app()->request->getParam("mode");
        $ed_id = Yii::app()->request->getParam("ed_id", 0);
        $sp_id = Yii::app()->request->getParam("sp_id", 0);
        $config = ModuleLoader::getConfig("epaper");                
        MediaManager::i()->setFolder($config["mediaDir"]);
        
        $pg_image = "";
        $imagefile = CUploadedFile::getInstanceByName("file"); 
        
      
         
        $title = uniqid();
        if(!is_null($imagefile)){
            $ext = $imagefile->getExtensionName();
            if($ext=="jpg" || $ext=="png" || $ext=="gif" || $ext=="jpeg"){
                //$pg_image = $monthDir.uniqid().".".$ext;      
             //   if($mode=="default"){
//                    $title = ucwords(implode(" ",Helpers::i()->extractTags(substr($imagefile->getName(),0,-3))));                
//                } else if($mode=="filename"){
                    $title = substr($imagefile->getName(),0,-4);                
//                }
                $pg_image = MediaManager::i()->upload($imagefile);
                //$imagefile->saveAs($baseDir.$uploadDir.$mediaDir.$pg_image);                
            } else {
                AjaxOutput::i()->setError("File must be jpg, png or gif.")->display();
            }
            
        } else {
            AjaxOutput::i()->setError("Please select a file to upload")->display();
        }
        
        $model = new EpaperPage();
        $model->pg_title=  $title;
        $model->pg_metadesc = "";
        $model->pg_metakeys = "";
        $model->pg_desc = "";
        $model->ed_id = $ed_id;
        $model->sp_id = $sp_id;
        $model->pg_order = $model->getMaxOrder($ed_id) + 1;
        $model->pg_file = $pg_image;
        $model->pg_cdata = "";
        if($model->validate()){
            $model->save();
            AjaxOutput::i()->setStatus(true)->display();
        } else {
            AjaxOutput::i()
                ->setStatus(false)
                ->setValidationStatus(false)
                ->setValidationErrors($model->getErrors())
                ->display(); 
        }
         
    }
    public function actionGet(){
        $id = Yii::app()->request->getParam("id");
        $model = EpaperPage::model()->findByPk($id);        
        if(!is_null($model)){
            AjaxOutput::i()->setStatus(true)->setData($model)->display();
        }
        AjaxOutput::i()->setStatus(false)->display();      
    }
    public function actionSave(){
        $params = Yii::app()->request->getParam("EpaperPageForm");
        
        $model = new EpaperPageForm();        
        $model->setAttributes($params);        
        $model->id = $params["id"];
        if($model->validate()){
            $save = $model->save();           
            if(is_array($save) || $save === false){
                AjaxOutput::i()->setStatus(false)->setValidationStatus(false)
                        ->setValidationErrors($save)
                        ->display();
            } else {
                AjaxOutput::i()->setStatus(true)->display();
            }
        }
        AjaxOutput::i()
                ->setStatus(false)
                ->setValidationStatus(false)
                ->setValidationErrors($model->getErrors())
                ->display();
    }    
    public function actionDelete(){
       $id = Yii::app()->request->getParam("id");        
       $form = new EpaperPage();
       $form->deletePage($id);
       AjaxOutput::i()->setStatus(true)->display();
    }
    
    public function actionImport(){
        $id = Yii::app()->request->getParam("id"); //pg_id
        
        $model = EpaperPage::model()->findByPk($id);
        if(!is_null($model)){
            if(trim($model->pg_cdata)!=""){
                $data = unserialize($model->pg_cdata);
                if(isset($data["area"])){
                    EpaperMap::model()->deleteAll("pg_id = :pg_id", array(":pg_id"=>$id));
                    foreach($data["area"] as $r){
                        $model2 = new EpaperMap();
                        $model2->mp_alias = uniqid();
                        if(isset($r["title"])){
                            $model2->mp_title = $r["title"];                            
                        }
                        $model2->mp_x = $r["x"];
                        $model2->mp_y = $r["y"];
                        $model2->mp_w = $r["w"];
                        $model2->mp_h = $r["h"];
                        $model2->mp_ratio = $data["ratio"];
                        $model2->pg_id = $id;
                        $model2->save();
                    }
                    $model->pg_cdata = "";
                    $model->save();
                    AjaxOutput::i()->setStatus(true)->display();
                }
            }
        }
        AjaxOutput::i()->display();
        
    }
    /*
    public function actionEditor(){
         
        $id = Yii::app()->request->getParam("id");
        $model = EpaperPage::model()->with("rEdition")->findByPk($id);
        if(is_null($model)){
            throw new CHttpException(404,"Not found");
        }
        $this->pageTitle = "Editor - ".$model->pg_title." - ".$model->rEdition->ed_title;
        $this->render("editor",array("model"=>$model));
    }
    public function actionSavepagedata(){
         
        $id = Yii::app()->request->getParam("pg_id");
        $area = Yii::app()->request->getParam("area",array());
        $ratio = Yii::app()->request->getParam("ratio");
        
        $data = array();
        foreach($area as $a){
            $a = explode(":",$a);
            $title = "";
            if(isset($a[4])){
                $title = str_replace(":","",$a[4]);
            }
            strip_tags($title);
            $data[] = array("x" => $a[0]*$ratio, "y" => $a[1]*$ratio, "w" => $a[2]*$ratio, "h" => $a[3]*$ratio, "title"=>$title);
        }
        $model = EpaperPage::model()->findByPk($id);
        if(!is_null($model)){
            $d["area"] = $data;
            $d["ratio"] = $ratio;           
            $model->pg_cdata = serialize($d);
            $model->save();
            AjaxOutput::i()->setStatus(true)->display();
        }
        AjaxOutput::i()->setStatus(false)->display();
    }
    public function actionView(){   
        $id = Yii::app()->request->getParam("pg_id");
        $x = Yii::app()->request->getParam("x");
        $y = Yii::app()->request->getParam("y");
        $w = Yii::app()->request->getParam("w");
        $h = Yii::app()->request->getParam("h");
        
        
        $config = ModuleLoader::getConfig("epaper");        
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];

        $model = EpaperPage::model()->findByPk($id);
        if(is_null($model)){
            throw new CHttpException(404,"Not found");
        }
  
        $image_path = Yii::getPathOfAlias("webroot").$uploadDir.$mediaDir.$model->pg_file;        
  
        $wimg = WideImage::load($image_path);
        $wimg->crop($x, $y, $w, $h)->output("jpg");
         
    }*/
}
