<?php
class SchedulerController extends AdminController{
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("ep_manage_scheduler");
    }
    public function actionIndex(){
        $this->pageTitle = "Set Publishing Schedule";
        $this->render("index",array("formModel"=>new EpaperSchedulerForm()));
    }
    public function actionLoadlist(){
        $data = (new EpaperSchedulerForm())->listAll();
        $data = array_reverse($data);
        $this->renderPartial("loadlist",array("data"=>$data));         
    }
    public function actionGet(){        
        $model = EpaperSchedulerForm::findByPk(Yii::app()->request->getParam("id"));
        if($model!==false){
            AjaxOutput::i()->setStatus(true)->setData($model);
        }
        AjaxOutput::i()->display();
    }
    public function actionSave(){
        $data = Yii::app()->request->getParam(get_class(new EpaperSchedulerForm()));
        $id = $data["id"];
        $edition_id = $data["edition_id"];
        $date = $data["date"];
        $time = $data["time"];
        
        $sc = EpaperSchedulerForm::findByPk($id);
        if($sc==false){
            $sc = new EpaperSchedulerForm();
        }
        $sc->edition_id = $edition_id;
        $sc->date = $date;
        $sc->time = $time;
        
        if($sc->validate()){
            $sc->save();
            AjaxOutput::i()->setStatus(true)->display();
        } else {
            AjaxOutput::i()->setValidationStatus(false)->setValidationErrors($sc->getErrors())->display();
        }
    }
    public function actionDelete(){
        $sc = EpaperSchedulerForm::findByPk(Yii::app()->request->getParam("id"));
        if($sc!=false){
            $sc->delete();
        }
        AjaxOutput::i()->setStatus(true)->display();
    }
    public function actionSuggest(){
        $term = Yii::app()->request->getParam("term");
        $data = [];
        $models = EpaperEdition::model()->with('rCategory')->findAll("ed_title LIKE :search AND ed_status='private'", array(":search"=>$term."%"));
        foreach($models as $r){
            $data[] = ["id"=>$r->ed_id,"label"=>$r->ed_title." - " .$r->rCategory->cat_title,"value"=>$r->ed_title." - " .$r->rCategory->cat_title];
        }
        echo json_encode($data);
    }
}