<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/

class SitemapController extends AdminController{
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("ep_generate_sitemap");
    }
    public function actionIndex(){ 
        $this->pageTitle = "Epaper Sitemap Generator";
        $this->render("index");
    }
    public function actionSettings(){
        $form = new EpaperSitemapSettings();
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            $form->setAttributes(Yii::app()->request->getParam("EpaperSitemapSettings"));
            if($form->validate()){
                $form->saveForm();
                AjaxOutput::i()->setStatus(true);
            } else {
                //AjaxOutput::i()->setStatus(false)->setValidationStatus(false)->setValidationErrors($form->getErrors());
            }
        }
        ob_start();
        $form->displayForm($this->createUrl("settings"));
        $data = ob_get_contents();
        ob_clean();
        AjaxOutput::i()->setData($data)->display();
    }
    public function actionLoadlist(){
                       
        $page = Yii::app()->request->getParam("page",1);
        $perpage = $this->perpage;
        $offset = ($page * $perpage) - $perpage;
        $data = EpaperEdition::model()->listMonths($perpage,$offset);
        $result = $this->renderPartial("loadlist",array("data"=>$data),true);
        AjaxOutput::i()->setData(array(
            "html"=>$result,
            "total"=>$data["total"]            
                ))->display();
    }
    public function actionDelete_editions(){
        $month = Yii::app()->request->getParam("month");
      
        $sitemapDir = Yii::app()->params["sitemapDir"];        
        $baseDir = Yii::getPathOfAlias("webroot");        
         
        if(file_exists($baseDir.$sitemapDir."epaper-".$month.".xml")){
            unlink($baseDir.$sitemapDir."epaper-".$month.".xml"); 
            SitemapGenerator::make();
        }
        AjaxOutput::i()->setStatus(true)->display();
    }
    public function actionGenerate_editions(){
        $gen = new SitemapGenerator();
        $month = Yii::app()->request->getParam("month");
        $firstDay = $month."-01";
        $lastDay = Helpers::i()->formatDate($firstDay,"Y-m-t");                
    
        $pg_frequency = EpaperSitemapSettings::i()->page_frequency;
        $pg_priority = EpaperSitemapSettings::i()->page_priority;        
        $include_maps = EpaperSitemapSettings::i()->include_maps;
        $map_frequency = EpaperSitemapSettings::i()->map_frequency;
        $map_priority = EpaperSitemapSettings::i()->map_priority;
        
         
        $sitemapDir = Yii::app()->params["sitemapDir"];        
        $baseDir = Yii::getPathOfAlias("webroot");        
        
        $config = ModuleLoader::getConfig("epaper");        
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];  
        
        if(!file_exists($baseDir.$sitemapDir)){
            mkdir($baseDir.$sitemapDir);
        }
         
        $controller = $this;
        
        $supp_models = EpaperSupp::model()->findAll();
        $supp_data = array();
        foreach($supp_models as $sm){
            $supp_data[$sm->sp_id] = $sm->sp_alias;
        }
         
        $models = EpaperEdition::model()->with(array("rPages"=>array("order"=>"sp_id, pg_order ASC")))->findAll("ed_date >= :firstDay AND ed_date <= :lastDay AND ed_status = 'public'",array(":firstDay"=>$firstDay,":lastDay"=>$lastDay));
        if(count($models)>0){
            foreach($models as $m){ 
                 
                $pages = $m->getRelated("rPages");
                 
                if(count($pages)>0){
                    foreach($pages as $p){  
                        unset($urlparam);
                        $pageIndex = EpaperPage::model()->getPageIndex($m->ed_id, $p->pg_id);
                        $urlparam["id"] = $m->ed_id;
                        $urlparam["alias"] = $m->ed_alias;
                        if($pageIndex>1){
                            $urlparam["page"] = $pageIndex;
                        }
                        if($p->sp_id > 0){
                            if(isset($supp_data[$p->sp_id])){
                                $urlparam["spid"] = $p->sp_id;
                                $urlparam["spalias"] = $supp_data[$p->sp_id];
                            }
                        }
                        if($pageIndex==1){
                            $location = $this->createAbsoluteUrl("//epaper/default/show",$urlparam);
                            $gen->addItem($location, $location, $pg_frequency, $pg_priority);                            
                            if(trim($m->ed_pdf)!=""){
                                $location = Yii::app()->getBaseUrl(true) . $uploadDir.$mediaDir.$m->ed_pdf;
                                $gen->addItem($location, $location, $pg_frequency, $pg_priority);
                            }                            
                        } else {
                            $location = $this->createAbsoluteUrl("//epaper/default/show",$urlparam);
                            $gen->addItem($location, $location, $pg_frequency, $pg_priority);                       
                        }
                        
                        if(trim($p->pg_pdf)!=""){
                            $location = Yii::app()->getBaseUrl(true) . $uploadDir.$mediaDir.$p->pg_pdf;
                            $gen->addItem($location, $location, $pg_frequency, $pg_priority);
                        }
                        
                        if($include_maps==true){
                            //$generatePage($p["pg_id"],$p["pg_cdata"]);
                            $mapModels = EpaperMap::model()->findAll("pg_id = :pg_id",array(":pg_id"=>$p->pg_id));
                            if(count($mapModels)>0){
                                foreach($mapModels as $m2){
                                    $location = $controller->createAbsoluteUrl("//epaper/default/map",array(
                                        "id"=>$m2->mp_id,"alias"=>$m2->mp_alias));
                                    $gen->addItem($location, $location, $map_frequency, $map_priority);
                                }
                            }
                        }
                    }
                }
            }
        }
        file_put_contents($baseDir.$sitemapDir."epaper-".$month.".xml", $gen->generateSitemap());
        SitemapGenerator::make();
        AjaxOutput::i()->setStatus(true)->display();
    }
    
    
    
    
    
    public function actionGenerate_category(){
        $gen = new SitemapGenerator();
        $sitemapDir = Yii::app()->params["sitemapDir"];        
        $baseDir = Yii::getPathOfAlias("webroot");  
        $models = EpaperCategory::model()->findAll();
        $cat_frequency = EpaperSitemapSettings::i()->category_frequency;
        $cat_priority = EpaperSitemapSettings::i()->category_priority;
        
        $home_frequency = EpaperSitemapSettings::i()->home_frequency;
        $home_priority = EpaperSitemapSettings::i()->home_priority;
        
        if(EpaperSitemapSettings::i()->include_home){            
            $location = $this->createAbsoluteUrl("//epaper/default/index");
            $gen->addItem($location, $location, $home_frequency, $home_priority);
        }
        
        if(count($models)>0){
            foreach($models as $m){
                $location = $this->createAbsoluteUrl("//epaper/default/index",array("id"=>$m->cat_id,"alias"=>$m->cat_alias));
                $gen->addItem($location, $location, $cat_frequency, $cat_priority);
            }
        }
        file_put_contents($baseDir.$sitemapDir."epaper.xml", $gen->generateSitemap());
        SitemapGenerator::make();
        AjaxOutput::i()->setStatus(true)->display();
    }
    public function actionDelete_category(){
        $month = Yii::app()->request->getParam("month");        
        $sitemapDir = Yii::app()->params["sitemapDir"];        
        $baseDir = Yii::getPathOfAlias("webroot");        
         
        if(file_exists($baseDir.$sitemapDir."epaper.xml")){
            unlink($baseDir.$sitemapDir."epaper.xml"); 
            SitemapGenerator::make();
        }
        AjaxOutput::i()->setStatus(true)->display();
    }
}