<?php

/**
 * This is the model class for table "epaper_supps".
 *
 * The followings are the available columns in table 'epaper_supps':
 * @property int $bkm_id
 * @property string $bkm_title
 * @property string $bkm_order
 * @property string $pg_id
 * @property int $ed_id 
 *
 * The followings are the available model relations:
 * @property EpaperPages $rPage
 */
class EpaperBookmark extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'epaper_bookmarks';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
                        array('bkm_title, bkm_order, ed_id, pg_id','required'),   
                        array('bkm_title', 'length', 'max'=>255),			
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rPage' => array(self::BELONGS_TO, 'EpaperPage', 'pg_id'),
                        'rEdition' => array(self::BELONGS_TO, 'EpaperEdition', 'ed_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'bkm_id' => 'Id',
			'bkm_title' => 'Title',
                        'bkm_order' => 'Title',
                        'pg_id' => 'Page',
			'ed_id' => 'Edition',
		);
	}

	 
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        public function getBookmarksByEdition($ed_id){
            $sql = "SELECT * FROM epaper_bookmarks "
                    . "INNER JOIN epaper_pages ON epaper_pages.pg_id = epaper_bookmarks.pg_id "
                    . "LEFT JOIN epaper_supps ON epaper_supps.sp_id = epaper_pages.sp_id "
                    . "WHERE epaper_bookmarks.ed_id = :ed_id ORDER BY bkm_order ASC";
            return Yii::app()->db->createCommand($sql)->queryAll(true, array(":ed_id"=>$ed_id));
        }
        
}
