<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
/**
 * This is the model class for table "epaper_categories".
 *
 * The followings are the available columns in table 'epaper_categories':
 * @property string $cat_id
 * @property string $cat_title
 * @property string $cat_alias
 * @property string $cat_desc
 * @property string $cat_image
 * @property string $cat_metadesc
 * @property string $cat_metakeys
 * @property string $cat_pid
 *
 * The followings are the available model relations:
 * @property EpaperEditions[] $epaperEditions
 * @property EpaperFeaturedCategories[] $epaperFeaturedCategories
 */
class EpaperCategory extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'epaper_categories';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('cat_title, cat_alias, cat_pid', 'required'),
			array('cat_title, cat_alias, cat_image', 'length', 'max'=>255),       
                        array('cat_desc, cat_metadesc, cat_metakeys', 'length', 'max'=>1000),   
                        array('cat_desc, cat_image, cat_metadesc, cat_metakeys','length', 'allowEmpty'=>true),
			array('cat_pid', 'length', 'max'=>11),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('cat_id, cat_title, cat_alias, cat_desc, cat_image, cat_metadesc, cat_metakeys, cat_pid', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                        'rCategoryChildren' => array(self::HAS_MANY, 'EpaperCategory', 'cat_pid'),
			'rEdition' => array(self::HAS_MANY, 'EpaperEdition', 'cat_id'),
			'rFeaturedCategory' => array(self::HAS_ONE, 'EpaperFeaturedCategory', 'cat_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'cat_id' => 'Id',
			'cat_title' => 'Title',
			'cat_alias' => 'Alias',
			'cat_desc' => 'Description',
			'cat_image' => 'Image',
			'cat_metadesc' => 'Meta Description',
			'cat_metakeys' => 'Meta Keywords',
                         
			'cat_pid' => 'Parent Category',
		);
	}
        
        

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('cat_id',$this->cat_id,true);
		$criteria->compare('cat_title',$this->cat_title,true);
		$criteria->compare('cat_alias',$this->cat_alias,true);
		$criteria->compare('cat_desc',$this->cat_desc,true);
		$criteria->compare('cat_image',$this->cat_image,true);
		$criteria->compare('cat_metadesc',$this->cat_metadesc,true);
		$criteria->compare('cat_metakeys',$this->cat_metakeys,true);
		$criteria->compare('cat_pid',$this->cat_pid,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EpaperCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        public function getFullHierarchyAsPlainArray($exclude=0,$include_zero=true){
            $recursion = function($records,$level=0) use (&$recursion, $exclude){
                $data = array();
                $level++;
                foreach($records as $k=>$r){  
                    if($k!=$exclude){
                      
                            $data[$k] = str_repeat("&#160;&#160;&#160;", ($level-1)*2 )."|— ".$r["cat_title"];    
                    
                        $data2 = $recursion($r["children"],$level);
                        $data =  $data + $data2; 
                    }
                }
                return $data;
            };
            $data = array();
            if($include_zero==true){
                $data["0"] = "{None}";                  
            }
           
            $records = $this->getFullHierarchy();
            foreach($records as $k=>$r){
                if($k!=$exclude){
                    $data[$k] = $r["cat_title"];
                    $data2 = $recursion($r["children"]);
                    $data = $data+ $data2;
                }
            }            
             
            
            return $data;
        }
        
        
        
        public function getFullHierarchy(){ 
               
              
            $data = Settings::i()->get("epaper_category_hierarchy"); 
            if($data!=""){
                return unserialize($data);
            } else {
                $data = $this->processCategoryHierarchy();                
                Settings::i()->save("epaper_category_hierarchy", serialize($data));
                return $data;
            }
        }
        
        public function processCategoryHierarchy(){
            $recursion = function(EpaperCategory $model) use(&$recursion){
                $data = array();
                $children = $model->getRelated("rCategoryChildren");                
                if(count($children)>0){
                    foreach($children as $child){                        
                        $data[$child->cat_id] = $child->attributes;
                        $data[$child->cat_id]["children"] = $recursion($child);
                        $data[$child->cat_id]["featured"] = $child->getRelated("rFeaturedCategory");                         
                    }                
                }
                return $data;
            };
            
            $data = array();
            $models = $this->findAll("cat_pid = 0");           
            if(count($models)>0){
                foreach($models as $model){ 
                    $data[$model->cat_id] = $model->attributes;                         
                    $data[$model->cat_id]["children"] = $recursion($model);                    
                    $data[$model->cat_id]["featured"] = $model->getRelated("rFeaturedCategory");
                }
            }
            
            Settings::i()->save("epaper_category_hierarchy", serialize($data));
            return $data;
        }
        
        
        
}
