<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
/**
 * This is the model class for table "epaper_editions".
 *
 * The followings are the available columns in table 'epaper_editions':
 * @property string $ed_id
 * @property string $ed_title
 * @property string $ed_alias
 * @property string $ed_desc
 * @property string $ed_date
 * @property string $ed_image
 * @property string $ed_pdf
 * @property string $ed_status
 * @property string $ed_metadesc
 * @property string $ed_metakeys
 * @property string $cat_id
 *
 * The followings are the available model relations:
 * @property EpaperCategories $cat
 * @property EpaperFeaturedEditions[] $epaperFeaturedEditions
 * @property EpaperPages[] $epaperPages
 */
class EpaperEdition extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'epaper_editions';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('ed_title, ed_date, ed_status,  cat_id', 'required'),
            array('ed_title, ed_alias, ed_image, ed_pdf', 'length', 'max' => 255),
            array('ed_desc, ed_metadesc, ed_metakeys', 'length', 'max' => 1000),
            array('ed_metadesc, ed_metakeys, ed_desc, ed_alias, ed_image, ed_pdf', 'length', 'allowEmpty' => true),
            array('ed_status', 'length', 'max' => 7),
            array('cat_id', 'length', 'max' => 11),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('ed_id, ed_title, ed_alias, ed_desc, ed_date, ed_image, ed_pdf, ed_status, ed_metadesc, ed_metakeys, cat_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'rCategory' => array(self::BELONGS_TO, 'EpaperCategory', 'cat_id'),
            'rFeaturedEdition' => array(self::HAS_MANY, 'EpaperFeaturedEdition', 'ed_id'),
            'rPages' => array(self::HAS_MANY, 'EpaperPage', 'ed_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'ed_id' => 'Edition Id',
            'ed_title' => 'Title',
            'ed_alias' => 'Alias',
            'ed_desc' => 'Description',
            'ed_date' => 'Date',
            'ed_image' => 'Image',
            'ed_pdf' => 'Pdf',
            'ed_status' => 'Status',
            'ed_metadesc' => 'Meta Description',
            'ed_metakeys' => 'Meta Keywords',
            'cat_id' => 'Category',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('ed_id', $this->ed_id, true);
        $criteria->compare('ed_title', $this->ed_title, true);
        $criteria->compare('ed_alias', $this->ed_alias, true);
        $criteria->compare('ed_desc', $this->ed_desc, true);
        $criteria->compare('ed_date', $this->ed_date, true);
        $criteria->compare('ed_image', $this->ed_image, true);
        $criteria->compare('ed_pdf', $this->ed_pdf, true);
        $criteria->compare('ed_status', $this->ed_status, true);
        $criteria->compare('ed_metadesc', $this->ed_metadesc, true);
        $criteria->compare('ed_metakeys', $this->ed_metakeys, true);
        $criteria->compare('cat_id', $this->cat_id, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return EpaperEdition the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    
    
     
    
    public function loadList($search="",$cat_id=0,$perpage=14,$offset=0){
        $where = "ed_title LIKE :search";
        $p[":search"] = "%$search%";
        if($cat_id > 0){
            $where .= " AND epaper_editions.cat_id = :cat_id ";
            $p[":cat_id"] = $cat_id;
        }
        
        $order = "ed_id";
        if (EpaperSettings::i()->orderby == EpaperSettings::ORDERBY_DATE) {
            $order = "ed_date";
        }
        
        $cmd = Yii::app()->db->createCommand();
        $records = $cmd->select("epaper_categories.*, epaper_editions.*, epaper_featured_editions.fed_id,  DATE_FORMAT(ed_date,'%d %b %Y') as ed_date")->from($this->tableName())
                ->where($where,$p)
                ->join("epaper_categories","epaper_categories.cat_id = epaper_editions.cat_id")
                ->leftJoin("epaper_featured_editions","epaper_featured_editions.ed_id = epaper_editions.ed_id")
                ->limit($perpage)->offset($offset)->order("epaper_editions.$order desc")
                ->queryAll();
        $cmd = Yii::app()->db->createCommand();
        $total = $cmd->select("COUNT(*)")->from($this->tableName())
                ->where($where,$p)->join("epaper_categories","epaper_categories.cat_id = epaper_editions.cat_id")
                ->leftJoin("epaper_featured_editions","epaper_featured_editions.ed_id = epaper_editions.ed_id")
                ->queryScalar();
        return array("records"=>$records,"total"=>$total);
        
    }    
    
    public function listMonths($limit=10,$offset=0){
        $data["total"] = Yii::app()->db->createCommand()
                ->select("COUNT(DISTINCT DATE_FORMAT(ed_date,'%M-%Y'))")
                ->from($this->tableName())->queryScalar();
        
        $data["records"] = Yii::app()->db->createCommand()
                ->selectDistinct("DATE_FORMAT(ed_date,'%M-%Y') as hmonth, DATE_FORMAT(ed_date,'%Y-%m') as nmonth")
                ->from($this->tableName())->offset($offset)
                ->limit($limit)->order("ed_date DESC")->queryAll();
        return $data;
    }
    
}
