<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
/**
 * This is the model class for table "epaper_featured_categories".
 *
 * The followings are the available columns in table 'epaper_featured_categories':
 * @property string $fcat_id
 * @property string $fcat_order
 * @property string $cat_id
 *
 * The followings are the available model relations:
 * @property EpaperCategories $cat
 */
class EpaperFeaturedCategory extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'epaper_featured_categories';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fcat_order, cat_id', 'required'),
			array('fcat_order, cat_id', 'length', 'max'=>11),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('fcat_id, fcat_order, cat_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rEpaperCategory' => array(self::BELONGS_TO, 'EpaperCategory', 'cat_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'fcat_id' => 'ID',
			'fcat_order' => 'Order',
			'cat_id' => 'Category',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('fcat_id',$this->fcat_id,true);
		$criteria->compare('fcat_order',$this->fcat_order,true);
		$criteria->compare('cat_id',$this->cat_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EpaperFeaturedCategory the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        
        public function add($cat_id) {
        $model = $this->find("cat_id = :cat_id", array(":cat_id" => $cat_id));
        if (is_null($model)) {
            $cmd = Yii::app()->db->createCommand("UPDATE " . $this->tableName() . " SET fcat_order = fcat_order+1");
            $cmd->execute();

            $featured = new EpaperFeaturedCategory();
            $featured->cat_id = $cat_id;
            $featured->fcat_order = 1;
           
           
            $featured->save();
            
        }
    }

    public function remove($cat_id) {
        $model = $this->find("cat_id = :cat_id", array(":cat_id" => $cat_id));
        if (!is_null($model)) {
            $cmd = Yii::app()->db->createCommand("UPDATE " . $this->tableName() . " SET fcat_order = fcat_order-1 WHERE fcat_order > :fcat_order");
            $cmd->execute(array(":fcat_order" => $model->fcat_order));
            $model->delete();
        }
    }
    
    public function listAll(){
        $cmd = Yii::app()->db->createCommand();
        $data["records"] = $cmd->select("*")->from($this->tableName())
                ->join("epaper_categories", "epaper_categories.cat_id = ".$this->tableName().".cat_id")
                ->order("fcat_order ASC")->queryAll();              
        return $data;
    }
}
