<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
/**
 * This is the model class for table "epaper_featured_editions".
 *
 * The followings are the available columns in table 'epaper_featured_editions':
 * @property string $fed_id
 * @property string $fed_order
 * @property string $ed_id
 *
 * The followings are the available model relations:
 * @property EpaperEditions $ed
 */
class EpaperFeaturedEdition extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'epaper_featured_editions';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('fed_order, ed_id', 'required'),
            array('fed_id, fed_order, ed_id', 'length', 'max' => 11),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('fed_id, fed_order, ed_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'rEpaperEdition' => array(self::BELONGS_TO, 'EpaperEdition', 'ed_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'fed_id' => 'Id',
            'fed_order' => 'Order',
            'ed_id' => 'Edition',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('fed_id', $this->fed_id, true);
        $criteria->compare('fed_order', $this->fed_order, true);
        $criteria->compare('ed_id', $this->ed_id, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return EpaperFeaturedEdition the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public function add($ed_id) {
        $model = $this->find("ed_id = :ed_id", array(":ed_id" => $ed_id));
        if (is_null($model)) {
            $cmd = Yii::app()->db->createCommand("UPDATE " . $this->tableName() . " SET fed_order = fed_order+1");
            $cmd->execute();

            $featured = new EpaperFeaturedEdition();
            $featured->ed_id = $ed_id;
            $featured->fed_order = 1;
            $featured->save();
        }
    }

    public function remove($ed_id) {
        $model = $this->find("ed_id = :ed_id", array(":ed_id" => $ed_id));
        if (!is_null($model)) {
            $cmd = Yii::app()->db->createCommand("UPDATE " . $this->tableName() . " SET fed_order = fed_order-1 WHERE fed_order > :fed_order");
            $cmd->execute(array(":fed_order" => $model->fed_order));
            $model->delete();
        }
    }
    
    public function listAll(){
        $cmd = Yii::app()->db->createCommand();
        $data["records"] = $cmd->select("*")->from($this->tableName())
                ->join("epaper_editions", "epaper_editions.ed_id = ".$this->tableName().".ed_id")
                ->order("fed_order ASC")->queryAll();              
        return $data;
    }
}
