<?php

/**
 * This is the model class for table "epaper_maps".
 *
 * The followings are the available columns in table 'epaper_maps':
 * @property string $mp_id
 * @property string $mp_title
 * @property string $mp_alias
 * @property string $mp_desc
 * @property string $mp_metakeys
 * @property string $mp_metadesc
 * @property string $mp_image
 * @property string $mp_x
 * @property string $mp_y
 * @property string $mp_w
 * @property string $mp_h
 * @property string $mp_ratio
 * @property string $pg_id
 *
 * The followings are the available model relations:
 * @property EpaperPages $pg
 */
class EpaperMap extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'epaper_maps';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('mp_title, mp_alias, mp_desc, mp_metakeys, mp_metadesc, mp_image, mp_x, mp_y, mp_w, mp_h, mp_ratio, pg_id, mp_next_link', 'length', 'allowEmpty'=>true),
			 
                        array('mp_title, mp_alias,  mp_metakeys, mp_metadesc', 'length', 'max'=>1000),
			array('mp_image', 'length', 'max'=>255),
			array('mp_x, mp_y, mp_w, mp_h, mp_ratio', 'length', 'max'=>10),
			array('pg_id, mp_next_link', 'length', 'max'=>11),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('mp_id, mp_title, mp_desc, mp_metakeys, mp_metadesc, mp_image, mp_x, mp_y, mp_w, mp_h, mp_ratio, pg_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rPage' => array(self::BELONGS_TO, 'EpaperPage', 'pg_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mp_id' => 'Mp',
			'mp_title' => 'Mp Title',
                        'mp_alias' => 'Mp Alias',
			'mp_desc' => 'Mp Desc',
			'mp_metakeys' => 'Mp Metakeys',
			'mp_metadesc' => 'Mp Metadesc',
			'mp_image' => 'Mp Image',
			'mp_x' => 'Mp X',
			'mp_y' => 'Mp Y',
			'mp_w' => 'Mp W',
			'mp_h' => 'Mp H',
			'mp_ratio' => 'Mp Ratio',
			'pg_id' => 'Pg Id',
                        
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('mp_id',$this->mp_id,true);
		$criteria->compare('mp_title',$this->mp_title,true);
                $criteria->compare('mp_alias',$this->mp_alias,true);
		$criteria->compare('mp_desc',$this->mp_desc,true);
		$criteria->compare('mp_metakeys',$this->mp_metakeys,true);
		$criteria->compare('mp_metadesc',$this->mp_metadesc,true);
		$criteria->compare('mp_image',$this->mp_image,true);
		$criteria->compare('mp_x',$this->mp_x,true);
		$criteria->compare('mp_y',$this->mp_y,true);
		$criteria->compare('mp_w',$this->mp_w,true);
		$criteria->compare('mp_h',$this->mp_h,true);
		$criteria->compare('mp_ratio',$this->mp_ratio,true);
		$criteria->compare('pg_id',$this->pg_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EpaperMap the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        public function doSearch($search="",$ed_id=0,$limit=15,$offset=0){
            $params[":search"] = "%$search%"; $where = "";
            if($ed_id > 0){
                $where .= " AND epaper_pages.ed_id = :ed_id";
                $params[":ed_id"] = $ed_id;
            }
        
            $db = Yii::app()->db->createCommand();
            $data["records"] = $db->select("*")->from($this->tableName())
                    ->join("epaper_pages", "epaper_pages.pg_id = epaper_maps.pg_id")
                    ->join("epaper_editions","epaper_editions.ed_id = epaper_pages.ed_id")
                    ->join("epaper_categories","epaper_categories.cat_id = epaper_editions.cat_id")
                    ->where("mp_title LIKE :search $where",$params)
                    ->offset($offset)
                    ->limit($limit)
                    ->queryAll();
            $db = Yii::app()->db->createCommand();
            $data["total"] = $db->select("COUNT(mp_id) AS total")->from($this->tableName())
                    ->join("epaper_pages", "epaper_pages.pg_id = epaper_maps.pg_id")
                    ->join("epaper_editions","epaper_editions.ed_id = epaper_pages.ed_id")
                    ->join("epaper_categories","epaper_categories.cat_id = epaper_editions.cat_id")                    
                    ->where("mp_title LIKE :search $where",$params)
                    ->queryScalar();
            return $data;
        }
        
        public static $stacks;
        public static function getPreviousMaps($model,$init=true){
            if($init){
                self::$stacks = [];
            }
            $prevModel = EpaperMap::model()->find("mp_next_link = :id", [":id"=>$model->mp_id]);
            if(!is_null($prevModel)){
                self::$stacks[] = $prevModel;
                self::getPreviousMaps($prevModel,false); 
            }
            return self::$stacks;
        } 
        public static function getNextMaps($model,$init=true){
            if($init){
                self::$stacks = [];
            }
            $nextModel = EpaperMap::model()->findByPk($model->mp_next_link);               
            if(!is_null($nextModel)){
                self::$stacks[] = $nextModel;
                self::getNextMaps($nextModel,false);
            }
            return self::$stacks;
        }
}
