<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
/**
 * This is the model class for table "epaper_pages".
 *
 * The followings are the available columns in table 'epaper_pages':
 * @property string $pg_id
 * @property string $pg_title
 * @property string $pg_file
 * @property string $pg_desc
 * @property string $pg_metadesc
 * @property string $pg_metakeys
 * @property string $pg_order
 * @property string $ed_id
 *
 * The followings are the available model relations:
 * @property EpaperEditions $ed
 */
class EpaperPage extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'epaper_pages';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('pg_title, pg_file,  pg_order, sp_id, ed_id', 'required'),
            array('pg_desc, pg_metadesc, pg_metakeys, pg_cdata','length','allowEmpty'=>true),
			array('pg_title, pg_file', 'length', 'max'=>255),
            array('pg_desc, pg_metadesc, pg_metakeys', 'length', 'max'=>1000),
			array('pg_order, ed_id', 'length', 'max'=>11),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('pg_id, pg_title, pg_file, pg_desc, pg_metadesc, pg_metakeys, pg_order, ed_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rEdition' => array(self::BELONGS_TO, 'EpaperEdition', 'ed_id'),
                        'rMap' => array(self::HAS_MANY, 'EpaperMap', 'pg_id'),
                        'rSupp' => array(self::BELONGS_TO, 'EpaperSupp', 'sp_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'pg_id' => 'Page Id',
			'pg_title' => 'Title',
			'pg_file' => 'File',
			'pg_desc' => 'Description',
			'pg_metadesc' => 'Meta Description',
			'pg_metakeys' => 'Meta Keywords',
			'pg_order' => 'Order',
			'pg_cdata' => 'Co-ordinates Data',
			'ed_id' => 'Edition',
                    'sp_id' => 'Supplementary'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('pg_id',$this->pg_id,true);
		$criteria->compare('pg_title',$this->pg_title,true);
		$criteria->compare('pg_file',$this->pg_file,true);
		$criteria->compare('pg_desc',$this->pg_desc,true);
		$criteria->compare('pg_metadesc',$this->pg_metadesc,true);
		$criteria->compare('pg_metakeys',$this->pg_metakeys,true);
		$criteria->compare('pg_order',$this->pg_order,true);
		$criteria->compare('pg_cdata',$this->pg_cdata,true);
		$criteria->compare('ed_id',$this->ed_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EpaperPage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        
        
        public function getMaxOrder($ed_id){
            $sql = "SELECT MAX(pg_order) FROM epaper_pages WHERE ed_id = :ed_id";
            $cmd = Yii::app()->db->createCommand($sql);
            $maxorder = $cmd->queryScalar(array(":ed_id"=>$ed_id));
            return $maxorder;
        }
        
        public function deletePage($id){
            $config = ModuleLoader::getConfig("epaper");                
            MediaManager::i()->setFolder($config["mediaDir"]);
        
            $model = $this->findByPk($id);
            
            //Delete Maps
            
            $models = EpaperMap::model()->findAll("pg_id = :pg_id", array(":pg_id"=>$id));
            if(count($models)>0){
                foreach($models as $mdl){
                    if(trim($mdl->mp_image) != ""){
                        MediaManager::i()->delete($mdl->mp_image);
                    }                    
                    $mdl->delete();
                }
            }
            
            
            if(!is_null($model)){                 
                if(trim($model->pg_file)!=""){
                    MediaManager::i()->delete($model->pg_file);                    
                }
                if(trim($model->pg_pdf)!=""){
                    MediaManager::i()->delete($model->pg_pdf);                    
                }
                $sql = "UPDATE epaper_pages SET pg_order = pg_order - 1 WHERE pg_order > :pg_order AND ed_id = :ed_id";
                $cmd = Yii::app()->db->createCommand($sql);
                $cmd->execute(array(":pg_order"=>$model->pg_order,":ed_id"=>$model->ed_id));            
                $model->delete();
            }
        }
        private $_pages;
        private $_ed_id;
        public function getPageIndex($ed_id,$pg_id){
            if($this->_ed_id != $ed_id){
                $sql = "SELECT * FROM epaper_pages WHERE ed_id = :ed_id ORDER BY sp_id, pg_order ASC";
                $this->_ed_id = $ed_id;
                $this->_pages = Yii::app()->db->createCommand($sql)->queryAll(true,array(":ed_id"=>$ed_id));
            }         
           
            foreach($this->_pages as $r){                                 
                if($pg_id == $r["pg_id"]){                    
                    $sp_id = $r["sp_id"];
                }
            }
             
            $index = 1;
            foreach($this->_pages as $r){                                 
                if($sp_id == $r["sp_id"]){                    
                    if($pg_id == $r["pg_id"]){                        
                        return $index;
                    }
                    $index++;
                }
            }
            return 0;             
        }
}
