<?php

/**
 * This is the model class for table "epaper_supps".
 *
 * The followings are the available columns in table 'epaper_supps':
 * @property int $sp_id
 * @property string $sp_name
 * @property string $sp_alias
 * @property int $cat_id 
 *
 * The followings are the available model relations:
 * @property EpaperPages $rPage
 */
class EpaperSupp extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'epaper_supps';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
                        array('sp_name, sp_order, cat_id','required'),
                        array('sp_alias','length','allowEmpty'=>true),
                        array('sp_name, sp_alias', 'length', 'max'=>255),			
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rPage' => array(self::HAS_MANY, 'EpaperPage', 'sp_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'sp_id' => 'Sp Id',
			'sp_name' => 'Title',
                        'sp_alias' => 'Alias',
			'cat_id' => 'Category',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	 

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return EpaperMap the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        public static function getAssoList(){
            $records = Yii::app()->db->createCommand()->select("*")->from("epaper_supps")
                    ->join("epaper_categories", "epaper_categories.cat_id = epaper_supps.cat_id")
                    ->order("epaper_supps.cat_id ASC, epaper_supps.sp_order ASC")
                    ->queryAll();
            $data = array("0"=>"None");
            foreach($records as $r){
                $data[$r["sp_id"]] = $r["cat_title"]." --- ".$r["sp_name"];
            }
            return $data;
        }
        
        public static function getSuppsFromEdition($ed_id){
            $sql = "SELECT DISTINCT epaper_pages.sp_id, epaper_supps.sp_name, epaper_supps.sp_alias, epaper_supps.sp_order FROM epaper_pages INNER JOIN epaper_supps ON epaper_supps.sp_id = epaper_pages.sp_id WHERE ed_id = :ed_id ORDER BY epaper_supps.sp_order";
            return Yii::app()->db->createCommand($sql)->queryAll(true,array(":ed_id"=>$ed_id));
        }
        
}
