<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperCategoryForm extends CFormModel{
    public $cat_id;
    public $cat_title;
    public $cat_alias;
    public $cat_image;
    public $cat_desc;
    public $cat_metadesc;
    public $cat_metakeys;
    public $cat_pid;
    
    public $deletefile;
    public $imagefile;
    
    public function rules()
    {
            // NOTE: you should only define rules for those attributes that
            // will receive user inputs.
            return array(
                    array('cat_title, cat_pid', 'required'),
                    array('cat_title, cat_alias, cat_image', 'length', 'max'=>255),      
                    array('cat_desc, cat_metadesc, cat_metakeys', 'length', 'max'=>1000),
                    array('cat_desc, cat_alias, cat_image, deletefile, cat_metadesc, cat_metakeys','length', 'allowEmpty'=>true),
                    array('cat_pid', 'length', 'max'=>11),
                    array('cat_pid','validatePid'),
                    array('imagefile', 'file', 'types' => 'jpg, jpeg, png, gif', 'allowEmpty'=>true),
                    // The following rule is used by search().
                    // @todo Please remove those attributes that should not be searched.
                    array('cat_id, cat_title, cat_alias, cat_desc, cat_image, cat_metadesc, cat_metakeys, cat_pid', 'safe', 'on'=>'search'),
            );
    }
    public function attributeLabels()
    {
            return array(
                    'cat_id' => 'Id',
                    'cat_title' => 'Title',
                    'cat_alias' => 'Alias',
                    'cat_desc' => 'Description',
                    'cat_image' => 'Image',
                    'cat_metadesc' => 'Meta Description',
                    'cat_metakeys' => 'Meta Keywords',
                    'cat_pid' => 'Parent Category',
                    'imagefile' => 'Image Upload',
                    'deletefile' => 'Delete File',
            );
    }
    public function validatePid(){
        if($this->cat_id==$this->cat_pid){
            $this->addError("cat_pid", "Category can not be parent of itself");
        }
    }
    
    public function save(){
        $config = ModuleLoader::getConfig("epaper");                
        MediaManager::i()->setFolder($config["mediaDir"]);
        
        $this->imagefile = CUploadedFile::getInstance($this, "imagefile");
        if($this->cat_id>0){            
            $model = EpaperCategory::model()->findByPk($this->cat_id);
            if(!is_null($model)){                
                //if new file upload or delete previous yes            
                if($this->deletefile=="1" || !is_null($this->imagefile)){                    
                    MediaManager::i()->delete($model->cat_image);
                    $model->cat_image = "";
                }
                $model->cat_pid = 0;
                if($model->cat_id>1 && $model->cat_id!=$model->cat_pid){
                    $model->cat_pid = $this->cat_pid;
                }
            }                        
        } else {
            $model = new EpaperCategory();        
            $model->cat_pid = $this->cat_pid;
        }
        $model->cat_title = $this->cat_title;
        $model->cat_alias = Helpers::i()->getAlias($this->cat_title, $this->cat_alias);
        $model->cat_desc = $this->cat_desc;
        $model->cat_metadesc = $this->cat_metadesc;
        $model->cat_metakeys = $this->cat_metakeys;
        $model->cat_image = MediaManager::i()->upload($this->imagefile);
        if($model->validate()){
            $model->save();
        }
    }



    //removed from 2.5
    public function _save(){
        $config = ModuleLoader::getConfig("epaper");        
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];
        $baseDir = Yii::getPathOfAlias("webroot");
        $monthDir = date("Y-m")."/";
        $cat_image = "";
        $this->imagefile = CUploadedFile::getInstance($this, "imagefile");       
        
        if($this->cat_id>0){
            
            $model = EpaperCategory::model()->findByPk($this->cat_id);
            if(!is_null($model)){                
                //if new file upload or delete previous yes
                $file = $baseDir.$uploadDir.$mediaDir.$model->cat_image;    
                 
                if($this->deletefile=="1" || !is_null($this->imagefile)){                    
                    if($model->cat_image!=""){ 
                        if(file_exists($file)){  
                            unlink($file);
                            $model->cat_image = "";
                        }
                    }
                }
                $model->cat_pid = 0;
                if($model->cat_id>1 && $model->cat_id!=$model->cat_pid){
                    $model->cat_pid = $this->cat_pid;
                }
            }                        
        } else {
            $model = new EpaperCategory();        
            $model->cat_pid = $this->cat_pid;
        }
        if(!file_exists($baseDir.$uploadDir)){
            mkdir($baseDir.$uploadDir);                   
        }
        if(!file_exists($baseDir.$uploadDir.$mediaDir)){
            mkdir($baseDir.$uploadDir.$mediaDir);
        }
        if(!file_exists($baseDir.$uploadDir.$mediaDir.$monthDir)){
            mkdir($baseDir.$uploadDir.$mediaDir.$monthDir);
        }
        
        if(!is_null($this->imagefile)){
            $cat_image = $monthDir.uniqid().".".$this->imagefile->getExtensionName();
            $this->imagefile->saveAs($baseDir.$uploadDir.$mediaDir.$cat_image);
        }
        
         
        $model->cat_title = $this->cat_title;
        $model->cat_alias = Helpers::i()->getAlias($this->cat_title, $this->cat_alias);
        $model->cat_desc = $this->cat_desc;
        $model->cat_metadesc = $this->cat_metadesc;
        $model->cat_metakeys = $this->cat_metakeys;
        if($cat_image!=""){
            $model->cat_image = $cat_image;
        }
        
        if($model->validate()){
            $model->save();
        }
      
    }
    
    public function delete($id){
        $config = ModuleLoader::getConfig("epaper");        
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];
        $baseDir = Yii::getPathOfAlias("webroot");
        
        $model = EpaperCategory::model()->findByPk($id);
        if(!is_null($model)){
            
            
            $editions = EpaperEdition::model()->findAll("cat_id = :cat_id",array(":cat_id"=>$model->cat_id));
            foreach($editions as $e){
                $editionform = new EpaperEditionForm();
                $editionform->delete($e->ed_id);
            }
            
            if(trim($model->cat_image)!=""){
                $file = $baseDir.$uploadDir.$mediaDir.$model->cat_image;
                if(file_exists($file) && !is_dir($file)){
                    unlink($file);
                } 
            }
            //Move sub categories to uncategoried
            EpaperCategory::model()->updateAll(array("cat_pid"=>1),"cat_pid = :cat_pid",array(":cat_pid"=>$model->cat_id)); 
            
            $model->delete();
        }
    }
}