<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperEditionForm extends CFormModel {

    public $ed_id;
    public $ed_title;
    public $ed_alias;
    public $ed_desc;
    public $ed_date;
    public $ed_image;
    public $ed_pdf;
    public $ed_status;
    public $ed_metadesc;
    public $ed_metakeys;
    public $cat_id;
    
    public $pdffile;
    public $imagefile;
    
    public $delete_pdf;
    public $delete_image;
    
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('ed_title, ed_date,  ed_status,  cat_id', 'required'),
            array('ed_title, ed_alias, ed_image, ed_pdf', 'length', 'max' => 255),
            array('ed_desc, ed_metadesc, ed_metakeys', 'length', 'max' => 1000),
            array('ed_metadesc, ed_metakeys, ed_desc, ed_alias, ed_image, ed_pdf', 'length', 'allowEmpty' => true),
            array('ed_status', 'length', 'max' => 7),
            array('cat_id', 'length', 'max' => 11),
            array('delete_pdf, delete_image', 'length', 'allowEmpty'=>true),

            array('pdffile', 'file', 'types' => 'pdf', 'allowEmpty'=>true),
    
            array('imagefile', 'file', 'types' => 'jpg, jpeg, png, gif', 'allowEmpty'=>true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('ed_id, ed_title, ed_alias, ed_desc, ed_date, ed_image, ed_pdf, ed_status, ed_metadesc, ed_metakeys, cat_id', 'safe', 'on' => 'search'),
        );
    }

    public function attributeLabels() {
        return array(
            'ed_id' => 'Edition Id',
            'ed_title' => 'Title',
            'ed_alias' => 'Alias',
            'ed_desc' => 'Description',
            'ed_date' => 'Date',
            'ed_image' => 'Image',
            'ed_pdf' => 'Pdf',
            'ed_status' => 'Status',
            'ed_metadesc' => 'Meta Description',
            'ed_metakeys' => 'Meta Keywords',
            'cat_id' => 'Category',
            'pdffile' => 'PDF File',
            'imagefile' => 'Image',
            
            'delete_image' => 'Delete Image',
            'delete_pdf' => 'Delete PDF',
        );
    }
    
    public function save(){
        $config = ModuleLoader::getConfig("epaper");                
        MediaManager::i()->setFolder($config["mediaDir"]);
        
        $this->imagefile = CUploadedFile::getInstance($this, "imagefile");
        $this->pdffile = CUploadedFile::getInstance($this, "pdffile");
        
        $ed_image = "";
        $ed_pdf = "";
        
        if($this->ed_id>0){
            //update
            $model = EpaperEdition::model()->findByPk($this->ed_id);
            if(!is_null($model)){                
                //if new file upload or delete previous yes
                //$image_file = $baseDir.$uploadDir.$mediaDir.$model->ed_image;    
                 
                if($this->delete_image=="1" || !is_null($this->imagefile)){                    
                    MediaManager::i()->delete($model->ed_image);
                    $model->ed_image = "";
                }
                 
                if($this->delete_pdf=="1" || !is_null($this->pdffile)){      
                    MediaManager::i()->delete($model->ed_pdf);
                    $model->ed_pdf = "";
                }
            } 
        } else {
            //insert            
            $model = new EpaperEdition();
        } 
        
        $ed_image = MediaManager::i()->upload($this->imagefile);
        $ed_pdf = MediaManager::i()->upload($this->pdffile);
        
        $model->ed_title = $this->ed_title;
        $model->ed_alias = Helpers::i()->getAlias($this->ed_title, $this->ed_alias);
        $model->ed_desc = $this->ed_desc;
        $model->ed_date = date("Y-m-d",strtotime($this->ed_date));
        $model->ed_status = $this->ed_status;
        $model->ed_metadesc = $this->ed_metadesc;
        $model->ed_metakeys = $this->ed_metakeys;
        $model->cat_id = $this->cat_id;
        if($ed_image!=""){
            $model->ed_image = $ed_image;
        }
        if($ed_pdf!=""){
            $model->ed_pdf = $ed_pdf;
        }
        if($model->validate()){
            $model->save();
        }
    }
    
    public function _save(){
        $config = ModuleLoader::getConfig("epaper");        
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];
        $baseDir = Yii::getPathOfAlias("webroot");
        $monthDir = date("Y-m")."/";
        
        $ed_image = "";
        $ed_pdf = "";
        
        if($this->ed_id>0){
            //update
            $model = EpaperEdition::model()->findByPk($this->ed_id);
            if(!is_null($model)){                
                //if new file upload or delete previous yes
                $image_file = $baseDir.$uploadDir.$mediaDir.$model->ed_image;    
                 
                if($this->delete_image=="1" || !is_null($this->imagefile)){                    
                    if($model->ed_image!=""){ 
                        if(file_exists($image_file)){  
                            unlink($image_file);                            
                        }
                        $model->ed_image = "";
                    }
                }
                
                $pdf_file = $baseDir.$uploadDir.$mediaDir.$model->ed_pdf;    
                 
                if($this->delete_pdf=="1" || !is_null($this->pdffile)){                    
                    if($model->ed_pdf!=""){ 
                        if(file_exists($pdf_file)){  
                            unlink($pdf_file);                            
                        }
                        $model->ed_pdf = "";
                    }
                }
            } 
        } else {
            //insert            
            $model = new EpaperEdition();
        }
        if(!file_exists($baseDir.$uploadDir)){
            mkdir($baseDir.$uploadDir);                   
        }
        if(!file_exists($baseDir.$uploadDir.$mediaDir)){
            mkdir($baseDir.$uploadDir.$mediaDir);
        }
        if(!file_exists( $baseDir.$uploadDir.$mediaDir.$monthDir)){
            mkdir($baseDir.$uploadDir.$mediaDir.$monthDir);
        }
        
        if(!is_null($this->imagefile)){
            $ed_image = $monthDir.uniqid().".".$this->imagefile->getExtensionName();
            $this->imagefile->saveAs($baseDir.$uploadDir.$mediaDir.$ed_image);
        }
        
        if(!is_null($this->pdffile)){
            $ed_pdf = $monthDir.uniqid().".".$this->pdffile->getExtensionName();
            $this->pdffile->saveAs($baseDir.$uploadDir.$mediaDir.$ed_pdf);
        }
        
        
        $model->ed_title = $this->ed_title;
        $model->ed_alias = Helpers::i()->getAlias($this->ed_title, $this->ed_alias);
        $model->ed_desc = $this->ed_desc;
        $model->ed_date = date("Y-m-d",strtotime($this->ed_date));
        $model->ed_status = $this->ed_status;
        $model->ed_metadesc = $this->ed_metadesc;
        $model->ed_metakeys = $this->ed_metakeys;
        $model->cat_id = $this->cat_id;
        if($ed_image!=""){
            $model->ed_image = $ed_image;
        }
        if($ed_pdf!=""){
            $model->ed_pdf = $ed_pdf;
        }
        if($model->validate()){
            $model->save();
        } 
         
    }
    
    public function delete($id){
        $config = ModuleLoader::getConfig("epaper");                
        MediaManager::i()->setFolder($config["mediaDir"]);
          
        $model = EpaperEdition::model()->findByPk($id);
        if(!is_null($model)){
            //@todo delete all the pages
            $pages = EpaperPage::model()->findAll("ed_id = :ed_id",array(":ed_id"=>$id));
            $page_form = new EpaperPage();
            if(count($pages)>0){
                foreach($pages as $page){                    
                    $page_form->deletePage($page->pg_id);
                }
            }
            
            if(trim($model->ed_image)!=""){
                MediaManager::i()->delete($model->ed_image);
            }
            
            if(trim($model->ed_pdf)!=""){
                MediaManager::i()->delete($model->ed_pdf);
            }
            
            
            $model->delete();
        }
    }

}
