<?php

class EpaperMapForm extends CFormModel {

    public $map_id;
    public $title;
    public $alias;
    public $description;
    public $metakeys;
    public $metadesc;
    public $image;
    public $delete_image;
    public $file;
    public $next_link_id;
   
    
    public function rules() {
        return array(
            array('map_id', 'required'),            
            array('title, alias, description, metakeys, metadesc, image, delete_image, file, next_link_id', 'length', 'allowEmpty' => true),
            array('next_link_id','length', 'max' => 11),
            array('title, alias, metakeys, metadesc', 'length', 'max' => 1000),
            array('image', 'length', 'max' => 255),
            array('file', 'file', 'types' => 'jpg, jpeg, png, gif', 'allowEmpty' => true),
        );
    }
    
    public function attributeLabels() {
        return array(
            'map_id' => 'Map Id',
            'title' => 'Title',
            'alias' => 'Alias',
            'description' => 'Description',
            'metakeys' => 'Meta Keywords',
            'metadesc' => 'Meta Description',
            'image' => 'Custom Image',
            'delete_image' => 'Delete Image',
            'file' => 'Custom Image Upload',    
            'next_link_id' => "Next Map ID",
            
        );
    }
     
    
    public function delete($mapid){
        $config = ModuleLoader::getConfig("epaper");                
        MediaManager::i()->setFolder($config["mediaDir"]);
        
        $model = EpaperMap::model()->findByPk($mapid);
        if(!is_null($model)){
            if($model->mp_image!=""){ 
                MediaManager::i()->delete($model->mp_image);                
            }
            $model->delete();
            return true;
        }
        return false;
    }

    public function save(){
        $config = ModuleLoader::getConfig("epaper");                
        MediaManager::i()->setFolder($config["mediaDir"]);
        
        $model = EpaperMap::model()->findByPk($this->map_id);
         
        if(!is_null($model)){  
            
            $model->mp_title = $this->title;
            $model->mp_desc = $this->description;
            $model->mp_metakeys = $this->metakeys;
            $model->mp_metadesc = $this->metadesc;
            $model->mp_next_link = $this->next_link_id;
           
            
            if(trim($this->title)=="" && trim($this->alias)==""){                 
                $model->mp_alias = uniqid();
            } else if(trim($this->title)!="" && trim($this->alias)==""){  
                $alias = Helpers::i()->getAlias($this->title, $this->alias);
                if(trim($alias) == ""){
                    $alias = uniqid();
                }
                $model->mp_alias = $alias;
            } else {                 
                $model->mp_alias = $this->alias;                 
            }
               
            if($this->delete_image=="1" || !is_null($this->file)){
                if($model->mp_image!=""){ 
                    MediaManager::i()->delete($model->mp_image);                    
                    $model->mp_image = "";
                }
            }
            
            if(!is_null($this->file)){                
                $model->mp_image = MediaManager::i()->upload($this->file);
            }
            
            if($model->validate()){
                $model->save();
                return true;
            }            
        }
        return false;
    }
    
    public function _save(){
        $config = ModuleLoader::getConfig("epaper");        
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];
        $baseDir = Yii::getPathOfAlias("webroot");
        $monthDir = date("Y-m")."/";
        
        $model = EpaperMap::model()->findByPk($this->map_id);
         
        if(!is_null($model)){  
            
            $model->mp_title = $this->title;
            $model->mp_desc = $this->description;
            $model->mp_metakeys = $this->metakeys;
            $model->mp_metadesc = $this->metadesc;
          
            
            if(trim($this->title)=="" && trim($this->alias)==""){                 
                $model->mp_alias = uniqid();
            } else if(trim($this->title)!="" && trim($this->alias)==""){  
                $alias = Helpers::i()->getAlias($this->title, $this->alias);
                if(trim($alias) == ""){
                    $alias = uniqid();
                }
                $model->mp_alias = $alias;
            } else {                 
                $model->mp_alias = $this->alias;                 
            }
              
            if(!file_exists($baseDir.$uploadDir)){
                mkdir($baseDir.$uploadDir);                   
            }
            if(!file_exists($baseDir.$uploadDir.$mediaDir)){
                mkdir($baseDir.$uploadDir.$mediaDir);
            }
            if(!file_exists( $baseDir.$uploadDir.$mediaDir.$monthDir)){
                mkdir($baseDir.$uploadDir.$mediaDir.$monthDir);
            }
            
            if($this->delete_image=="1" || !is_null($this->file)){
                if($model->mp_image!=""){ 
                    $image_file = $baseDir.$uploadDir.$mediaDir.$model->mp_image;    
                    
                    if(file_exists($image_file)){                     
                        unlink($image_file);                            
                    }
                    $model->mp_image = "";
                }
            }
            
            if(!is_null($this->file)){
                $image = $monthDir.$this->map_id."_".uniqid().".".$this->file->getExtensionName();
                $this->file->saveAs($baseDir.$uploadDir.$mediaDir.$image);
                $model->mp_image = $image;
            }
            
            if($model->validate()){
                $model->save();
                return true;
            }            
        }
        return false;
    }
}
