<?php

class EpaperPageForm extends CFormModel {
     public $id;
     public $title;
     public $description;
     public $meta_description;
     public $meta_keywords;
     public $pdf_file;     
     public $delete_pdf;
     public $sp_id;
     public $model;
     
     public function rules() {
        return array(
            array('title', 'required'),            
            array('description, meta_description, meta_keywords,  delete_pdf, sp_id', 'length', 'allowEmpty' => true),            
            array('title, description, meta_description, meta_keywords', 'length', 'max' => 255),
            array('pdf_file', 'file', 'types' => 'pdf', 'allowEmpty' => true),
        );
    }
     
	 public function attributeLabels() {
        return array(
            'sp_id' => 'Supplementary Page',
             
        );
    }
    
    public function save(){
        $config = ModuleLoader::getConfig("epaper");                
        MediaManager::i()->setFolder($config["mediaDir"]);
        $filename = "";
        $model = EpaperPage::model()->findByPk($this->id);
        if(is_null($model)){
           return false; 
        }
        $model->sp_id = $this->sp_id;
        $model->pg_title = $this->title;
        $model->pg_desc = $this->description;
        $model->pg_metadesc = $this->meta_description;
        $model->pg_metakeys = $this->meta_keywords;
        
        if($this->delete_pdf){
            MediaManager::i()->delete($model->pg_pdf);
            $filename = "";
        }
         
        $uploadedFile = CUploadedFile::getInstance($this, "pdf_file");
        if(!is_null($uploadedFile)){
            $filename = MediaManager::i()->upload($uploadedFile,$model->pg_pdf);
        }
        
        $model->pg_pdf = $filename;
        if($model->validate()){           
            $model->save();
            return true;
        }
        
       
        
        return $model->getErrors();
    }
}