<?php

class EpaperSchedulerForm extends CFormModel{
    public $id;
    public $edition_id;
    public $date;
    public $time;
    
    public function __construct($scenario = '') {
        parent::__construct($scenario);
        //$this->id = uniqid();
    }
    
    public function rules() {
        return array(
            array('edition_id, date, time', 'required'),            
            array('id', 'length', 'allowEmpty' => true),
            array('edition_id', 'validateEdition'),
            array('date', 'validateDate'),            
        );
    }
    
    public function attributeLabels() {
        return array(
            "edition_id" => "Edition"
        );
    }
    
    public function validateEdition(){
        
        $model = EpaperEdition::model()->findByPk($this->edition_id);
        if($this->isEditionScheduled($this->edition_id,$this->id)){
            $this->addError("edition_id", "Edition is already scheduled");
            return false;
        }
        if(is_null($model)){
            $this->addError("edition_id", "Edition is not available");
            return false;
        }
        if($model->ed_status=="public"){
            $this->addError("edition_id", "Edition must be private");
            return false;
        }                
        return true;
    }
    
    public function validateDate(){
        $datetime = strtotime($this->date . " " . $this->time);
        if($datetime<time()){
            $this->addError("date", "Scheduled date must be in future");
            return false;
        }
        return true;
    }


    public function isEditionScheduled($edition_id,$id){
        $records = $this->listAll();
        if(count($records)>0){
            foreach($records as $r){
                 
                if($r["edition_id"]==$edition_id && $r["id"]!=$id){
                    return true;
                }
            }
        }        
        return false;
    }
    
    public function listAll(){
        $tasks = Settings::i()->get("tasks", __CLASS__);
        if($tasks!==false){
            return unserialize($tasks);
        }
        return array();;
    }
     
    public static function findByPk($id){
        $class = __CLASS__;
        
        $records = (new $class())->listAll();
        if(count($records)>0){
            foreach($records as $r){
                if($r["id"]==$id){
                    $obj = new $class();
                    $obj->id = $id;
                    $obj->edition_id = $r["edition_id"];
                    $obj->date = $r["date"];
                    $obj->time = $r["time"];
                    return $obj;
                }
            }
        }        
        return false;
    }
    
    public function save(){ 
        $records = $this->listAll();
        $newrecords = $records;
        if(count($records)>0){
            $n=0;
            foreach($records as $r){
                if($r["id"]==$this->id){
                    $newrecords[$n]["edition_id"] = $this->edition_id;
                    $newrecords[$n]["date"] = $this->date;                    
                    $newrecords[$n]["time"] = $this->time;                    
                    Settings::i()->save("tasks", serialize($newrecords), __CLASS__);
                    return true;
                }
                $n++;
            }            
        }        
        $newrecords[] = array(
            "id" => uniqid(),
            "edition_id" => $this->edition_id,
            "date" => $this->date,
            "time" => $this->time
        );
        Settings::i()->save("tasks", serialize($newrecords), __CLASS__);
        return true;     
    }
    
    public function delete(){
        
        $rearrange = function($array){
            $new = array();
            if(count($array)>0){
                foreach($array as $k=>$v){
                    $new[] = $v;
                }
            }
            return $new;
        };
        
        $records = $this->listAll();
        $newrecords = $records;
        if(count($records)>0){
            $n=0;
            foreach($records as $r){
                if($r["id"]==$this->id){
                    unset($newrecords[$n]);                    
                    Settings::i()->save("tasks", serialize($rearrange($newrecords)), __CLASS__);
                    return true;
                }
                $n++;
            }            
        }        
        return true;
    }
    
    public function run(){
        $time = time();
        $records = $this->listAll();
        if(count($records)>0){
            foreach($records as $r){
                $stime = strtotime($r["date"]." ".$r["time"]);                
                if($time>=$stime){                     
                    $model = EpaperEdition::model()->findByPk($r["edition_id"]);
                    if(!is_null($model)){                       
                        $model->ed_status = 'public';
                        $model->save();
                        $data =  EpaperSchedulerForm::findByPk($r["id"]);
                        if($data!=false){
                            $data->delete();
                        }
                    }
                }
            }
        }        
        return false;
    } 
}