<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperCategoryMenuitem extends AbstractMenuitem {
    public $cat_id;
    public function adminForm() {
        echo "<div class='form-group'>";
        echo $this->form->label($this, "cat_id");
        echo $this->form->dropDownList($this,"cat_id",  EpaperCategory::model()->getFullHierarchyAsPlainArray(0,false),array("class"=>"form-control"));        
        echo $this->form->error($this, "cat_id");
        echo "</div>";
    }

    public function getLink($arg, $data) {
        $category = EpaperCategory::model()->findByPk($data["cat_id"]);
        if(!is_null($category)){
            return Yii::app()->createUrl("//epaper/default/index",array("id"=>$data["cat_id"],"alias"=>$category->cat_alias));                    
        }
        return "#";
    }

    public function rules() {
        $rules = parent::rules();                 
        $rules[] = array("cat_id","required");
        return $rules;
    }
    public function attributeLabels() {
        $labels = parent::attributeLabels();
        $labels["cat_id"] = "Category";
        return $labels;
    }

}