<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperEditionMenuitem extends AbstractMenuitem {
    public $ed_id;
    public function adminForm() {
        echo "<div class='form-group'>";
        echo $this->form->label($this, "ed_id");
        echo $this->form->textField($this, "ed_id",array("class"=>"form-control"));
        echo $this->form->error($this, "ed_id");
        echo "</div>";
    }

    public function getLink($arg, $data) {
        $edition = EpaperEdition::model()->findByPk($data["ed_id"]);
        if(!is_null($edition)){
            return Yii::app()->createUrl("//epaper/default/show",array("id"=>$data["ed_id"],"alias"=>$edition->ed_alias));                    
        }
        return "#";
    }

    public function rules() {
        $rules = parent::rules();                 
        $rules[] = array("ed_id","required");
        return $rules;
    }
    public function attributeLabels() {
        $labels = parent::attributeLabels();
        $labels["ed_id"] = "Edition Id";
        return $labels;
    }

}