<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperAreaMapSettings extends AbstractAdminSettingsForm{
    
     
    public $pos_h;
    public $pos_v;
    
    public $image;
 
    public $file;
 
    public $merge_opacity = 100;
    public $merge_style = "nomerge";
    
    public function __construct() {
        parent::__construct();
        $obj = $this;
        
        $this->onBeforeSavingForm = function(CEvent $event) use (&$obj){
            
            $path = Yii::getPathOfAlias("webroot").Yii::app()->params["uploadDir"];
            if(isset($_POST["delete-image"])){
                
                $image = Settings::i()->get("image", "EpaperAreaMapSettings");
                if(file_exists($path.$image) && !is_dir($path.$image)){
                    unlink($path.$image);
                }
                Settings::i()->save("image", "" ,get_called_class());
                Settings::i()->init();
                $obj->image = "";
            }
            $up = CUploadedFile::getInstance($obj, "file");
            if(!is_null($up)){                
                $image = Settings::i()->get("image", "EpaperAreaMapSettings");
                if(file_exists($path.$image)  && !is_dir($path.$image)){
                    unlink($path.$image);
                }
                $filename = uniqid();                           
                $file = $path.$filename.".".$up->extensionName;
                $up->saveAs($file);
                $obj->image = $filename.".".$up->extensionName;
                $obj->file = "";
            } else {
                $obj->image = Settings::i()->get("image", "EpaperAreaMapSettings");
            }
        };
    }

    public function getExcludedProperties() {
        return array(
            "file"
        );
    }
    public function rules() {
        $rules = parent::rules();       
        $rules[] = array(["pos_h","pos_v","merge_opacity","merge_style"], "required");        
        $rules[] = array("image", "length","allowEmpty"=>true);
        $rules[] = array('file', 'file', 'types' => 'jpg, jpeg', 'allowEmpty'=>true);
        return $rules;
    }
    
    public function attributeLabels() {
        $attr = parent::attributeLabels();
        $attr["file"] = "Image";
        $attr["merge_opacity"] = "Opacity(%)";
        $attr["merge_style"] = "Merge Style";
        $attr["pos_h"] = "Horizontal Position";
        $attr["pos_v"] = "Vertical Position";
        
        return $attr;
    }
     
    
    public function adminForm() {         
        $imgurl = Yii::app()->getBaseUrl().Yii::app()->params["uploadDir"].$this->image;        
        $imgtag = CHtml::image($imgurl,"",array("class"=>"thumbnail","id"=>"image","style"=>"max-width:600px"));
        echo CHtml::link($imgtag,$imgurl);
        echo CHtml::checkBox("delete-image")." Delete Image <br /><br />";
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "merge_style");
        echo $this->form->dropDownList($this, "merge_style",[
            "merge"=>"Merge In Image","nomerge"=>"Do not merge"
        ],array("class"=>"form-control"));        
        echo $this->form->error($this, "merge_style");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "merge_opacity");
        echo $this->form->textField($this, "merge_opacity",array("class"=>"form-control"));
        echo $this->form->error($this, "merge_opacity");
        echo CHtml::closeTag("div");        
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "file");
        echo $this->form->fileField($this, "file",array("class"=>"form-control"));
        echo $this->form->error($this, "file");
        //echo "Note: If you upload a logo then you will have to refresh this page to see the new logo";
        echo CHtml::closeTag("div");         
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "pos_h");
        echo $this->form->dropDownList($this, "pos_h",[
            "left"=>"Left","right"=>"Right","center"=>"Center",
        ],array("class"=>"form-control"));        
        echo $this->form->error($this, "pos_h");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "pos_v");
        echo $this->form->dropDownList($this, "pos_v",[
            "top"=>"Top","bottom"=>"Bottom"
        ],array("class"=>"form-control"));        
        echo $this->form->error($this, "pos_v");
        echo CHtml::closeTag("div");
        
        ?>
    <script>
     var formElement = document.getElementById("formSettings_<?php echo get_called_class() ?>");
            formElement.addEventListener("formAjaxResponse", function(e) {          
              $("#image").attr("src","<?php echo Yii::app()->getBaseUrl(true).Yii::app()->params["uploadDir"] ?>"+e.detail.data.image+"?s="+Math.random());
              $("input[type=file]").val("");
              $("#delete-image").prop("checked",false);               
            });
    </script>
<?php
    }
    
    
    
}