<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperPopupSettings extends AbstractAdminSettingsForm{
    
    
    
    public $extra_width = 20;
    public $extra_height = 85;
    
    public $minimum_width = 500;
    public $minimum_height = 500;
    
    public $enable_logo = false;
    public $enable_social = true;
    
    public $top_adcode;
    public $bottom_adcode;
    public $left_adcode;
    public $right_adcode;
    
    public $show_title = true;

    public $enable_dialog = false;
    public $dialog_width = 900;
    public $dialog_height = 600;

    public function rules() {
        $rules = parent::rules();
        $rules[] = array("extra_width, dialog_width, dialog_height, extra_height, minimum_width, minimum_height", "required");
        $rules[] = array("extra_width, dialog_width, dialog_height, extra_height, minimum_width, minimum_height", "numerical");
        $rules[] = array("enable_social, enable_dialog, show_title, top_adcode, bottom_adcode, left_adcode, right_adcode, enable_logo","length", "allowEmpty"=>true);
        return $rules;
    }
    
    public function attributeLabels() {
        $l = parent::attributeLabels();
        $l["enable_dialog"] = "Enble Modal Window instead of Popup";
        $l["dialog_width"] = "Width of Modal Window";
        $l["dialog_height"] = "Height of Modal Window";
    }
    
    public function adminForm() {
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "enable_logo");
        echo "&nbsp;".$this->form->checkBox($this,"enable_logo");
        echo $this->form->error($this, "enable_logo");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "enable_social");
        echo "&nbsp;".$this->form->checkBox($this,"enable_social");
        echo $this->form->error($this, "enable_social");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "show_title");
        echo "&nbsp;".$this->form->checkBox($this,"show_title");
        echo $this->form->error($this, "show_title");
        echo CHtml::closeTag("div");
        
        foreach(array("extra_width","extra_height","minimum_width","minimum_height") as $r){
            echo CHtml::openTag("div",array("class"=>"form-group"));
            echo $this->form->label($this, $r);
            echo $this->form->textField($this, $r,array("class"=>"form-control"));
            echo $this->form->error($this, $r);
            echo CHtml::closeTag("div");
        }
        
        foreach(array("top_adcode","bottom_adcode","left_adcode","right_adcode") as $r){
            echo CHtml::openTag("div",array("class"=>"form-group"));
            echo $this->form->label($this, $r);
            echo $this->form->textArea($this, $r,array("class"=>"form-control"));
            echo $this->form->error($this, $r);
            echo CHtml::closeTag("div");
        }
         
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "enable_dialog");
        echo "&nbsp;".$this->form->checkBox($this,"enable_dialog");
        echo $this->form->error($this, "enable_dialog");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, 'dialog_width');
        echo $this->form->textField($this, 'dialog_width',array("class"=>"form-control"));
        echo $this->form->error($this, 'dialog_width');
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, 'dialog_height');
        echo $this->form->textField($this, 'dialog_height',array("class"=>"form-control"));
        echo $this->form->error($this, 'dialog_height');
        echo CHtml::closeTag("div");
        
    }
    
    
    
}