<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperSettings extends AbstractAdminSettingsForm{
    public $home_pagetitle;
    public $home_metadesc;
    public $home_metakeys;    
    
    public $editions_perpage = 18;
    public $orderby = self::ORDERBY_DATE;
    public $urlmode = self::URLMODE_ALIAS;
    
    public $clear_cache;
    public $pdf_download_mode = self::DOWNLOAD_MODE_DIRECT;
    
    public $unpublish_from = "01-Jan-1970";
    
    const ORDERBY_ID = "id";
    const ORDERBY_DATE = "date";
    
    const URLMODE_ROOT = "root";
    const URLMODE_ALIAS = "alias";
    
    const DOWNLOAD_MODE_DIRECT = "direct";
    const DOWNLOAD_MODE_PHP = "php";
    
    public $enable_search = false;
    public $enable_pdf2jpg = false;
    public $enable_bookmarks = false;
    
    public function __construct() {
        parent::__construct();
        $obj = $this;
        $this->onBeforeSavingForm = function(CEvent $event) use (&$obj) {
            if($obj->clear_cache==true){
                $path = Yii::getPathOfAlias("application.runtime.epaper_imagecache");
                $files = glob($path."/*"); 
                foreach($files as $file){ 
                  if(is_file($file)){
                    unlink($file); 
                  }
                }
            }
            $obj->clear_cache="";
        };
    }
    
    public function rules() {
        $rules = parent::rules();
        $rules[] = array("editions_perpage, pdf_download_mode, urlmode, orderby", "required");
        $rules[] = array("unpublish_from, enable_search, enable_pdf2jpg, enable_bookmarks, home_pagetitle, home_metadesc, home_metakeys, clear_cache","length", "allowEmpty"=>true);
        return $rules;
    }
    
    public function attributeLabels() {
        $attr = parent::attributeLabels();
        $attr["home_pagetitle"] = "Epaper Home Title";
        $attr["home_metadesc"]= "Epaper Home Description";
        $attr["home_metakeys"] = "Epaper Home Keywords";
        $attr["editions_perpage"] = "No of Editions perpage";
        $attr["urlmode"] = "Url Rewriting Mode";
        $attr["orderby"] = "Order Editions According To...";
        $attr["clear_cache"] = "Check this to clear cropped image cache";
        $attr["enable_pdf2jpg"] = "Enable PDF to JPG Converter";
        return $attr;
    }
    public function getExcludedProperties() {
        return array(
            "clear_cache"
        );
    }
    public function adminForm() {
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "home_pagetitle");
        echo $this->form->textField($this, "home_pagetitle",array("class"=>"form-control"));
        echo $this->form->error($this, "home_pagetitle");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "home_metadesc");
        echo $this->form->textArea($this, "home_metadesc",array("class"=>"form-control"));
        echo $this->form->error($this, "home_metadesc");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "home_metakeys");
        echo $this->form->textArea($this, "home_metakeys",array("class"=>"form-control"));
        echo $this->form->error($this, "home_metakeys");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "editions_perpage");
        echo $this->form->textField($this, "editions_perpage",array("class"=>"form-control"));
        echo $this->form->error($this, "editions_perpage");
        echo CHtml::closeTag("div");
        
        $urlmodes = array(
            self::URLMODE_ALIAS => "Like example.com/epaper/xxx/xxx/",
            self::URLMODE_ROOT => "Like example.com/xxx/xxx/"
        );
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "urlmode");
        echo $this->form->dropDownList($this, "urlmode",$urlmodes,array("class"=>"form-control"));
        echo $this->form->error($this, "urlmode");
        echo CHtml::closeTag("div");
        
        $orders = array(
            self::ORDERBY_ID => "ID",
            self::ORDERBY_DATE => "Date"
        );
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "orderby");
        echo $this->form->dropDownList($this, "orderby",$orders,array("class"=>"form-control"));
        echo $this->form->error($this, "orderby");
        echo CHtml::closeTag("div");
        
        $pdf_download_modes = array(
            self::DOWNLOAD_MODE_DIRECT => "Direct",
            self::DOWNLOAD_MODE_PHP => "Via PHP"
        );
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "pdf_download_mode");
        echo $this->form->dropDownList($this, "pdf_download_mode",$pdf_download_modes,array("class"=>"form-control"));
        echo $this->form->error($this, "pdf_download_mode");
        echo CHtml::closeTag("div");
        
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "clear_cache");
        echo "&nbsp;".$this->form->checkBox($this,"clear_cache");
        echo $this->form->error($this, "clear_cache");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "unpublish_from");
        echo $this->form->textField($this, "unpublish_from",array("class"=>"form-control"));
        echo $this->form->error($this, "unpublish_from");
        echo CHtml::closeTag("div");
        
        
        foreach(["search","pdf2jpg","bookmarks"] as $attr){        
            echo CHtml::openTag("div",array("class"=>"form-group"));
            echo $this->form->label($this, "enable_".$attr);
            echo "&nbsp;".$this->form->checkBox($this,"enable_".$attr);
            echo $this->form->error($this, "enable_".$attr);
            echo CHtml::closeTag("div");        
        }
        
         
        
        ?>
<script>
$(document).ready(function(){
    $("#<?php echo get_class($this) ?>_unpublish_from").datepicker({
        dateFormat: "dd-M-yy",        
        changeMonth: true,
        changeYear: true,    
        minDate: "-60Y",
        maxDate: "+5Y",
    });
});    
</script>
<?php
        
    }
}