<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperSitemapSettings extends AbstractAdminSettingsForm{
    
    public $include_home = true;
    
    public $include_maps = true;    
    
    public $page_priority = "0.5";
    public $page_frequency = "never";
    
    public $category_priority = "0.5";
    public $category_frequency = "never";
    
    public $map_priority = "0.5";
    public $map_frequency = "never";
    
    public $home_priority = "0.5";
    public $home_frequency = "always";
      
    
    public function rules() {
        $rules = parent::rules(); 
        $rules[] = array("include_home,   include_maps, "
            . "page_priority, page_frequency, "
            . "category_priority, category_frequency, "
            . "map_priority, map_frequency, "
            . "home_priority, home_frequency ","length", "allowEmpty"=>true);
        return $rules;
    }
    
    public function attributeLabels() {
        $labels = parent::attributeLabels();
        $labels["include_home"] = "Include Epaper Home";
         
        $labels["include_maps"] = "Include Area Maps"; 
        $labels["home_priority"] = "Epaper Home Priority"; 
        $labels["home_frequency"] = "Epaper Home Frequency"; 
        return $labels;
    }
    
    public function adminForm() {
        $freqlist = array(
            "always"=>"Always",
            "hourly"=>"Hourly",
            "daily"=>"Daily",
            "weekly"=>"Weekly",
            "monthly"=>"Monthly",
            "yearly"=>"Yearly",
            "never"=>"Never",
            ""=>"[Do not include]"
        );
        
        foreach(array("home","maps") as $p){
            echo CHtml::openTag("div",array("class"=>"form-group"));            
            echo $this->form->checkBox($this,"include_".$p);
            echo "&nbsp;".$this->form->label($this, "include_".$p);
            echo $this->form->error($this, "include_".$p);
            echo CHtml::closeTag("div");
        }
        
        echo "<div class='row'>";        
        echo "<div class='col-xs-6'>";
            foreach(array("home","page","category","map") as $p){
                echo CHtml::openTag("div",array("class"=>"form-group"));
                echo $this->form->label($this, $p."_frequency");                
                echo $this->form->dropDownList($this,$p."_frequency",$freqlist, array("class"=>"form-control"));
                echo $this->form->error($this, $p."_frequency");
                echo CHtml::closeTag("div");
            }            
        echo "</div>";        
        echo "<div class='col-xs-6'>";
            foreach(array("home","page","category","map") as $p){
                echo CHtml::openTag("div",array("class"=>"form-group"));
                echo $this->form->label($this, $p."_priority");                
                echo $this->form->textField($this, $p."_priority",array("class"=>"form-control"));
                echo $this->form->error($this, $p."_priority");
                echo CHtml::closeTag("div");
            }
        echo "</div>";
        echo "</div>";
         
    }

}