<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EpaperThumbBoxSettings extends AbstractAdminSettingsForm{
    

    public $width = 150;
    public $height = 200;
    public $crop = false;
    public $show_titles = false;
    
    public function rules() {
        $rules = parent::rules(); 
        $rules[] = array("width, height","required");
        $rules[] = array("width, height","numerical");
        $rules[] = array("crop, show_titles","length", "allowEmpty"=>true);
        return $rules;
    }
    
    public function adminForm() {        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "height");                
        echo $this->form->textField($this, "height",array("class"=>"form-control"));
        echo $this->form->error($this, "height");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "width");                
        echo $this->form->textField($this, "width",array("class"=>"form-control"));
        echo $this->form->error($this, "width");
        echo CHtml::closeTag("div");
                
        echo CHtml::openTag("div",array("class"=>"form-group"));            
        echo $this->form->checkBox($this,"crop");
        echo "&nbsp;".$this->form->label($this, "crop");
        echo $this->form->error($this, "crop");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));            
        echo $this->form->checkBox($this,"show_titles");
        echo "&nbsp;".$this->form->label($this, "show_titles");
        echo $this->form->error($this, "show_titles");
        echo CHtml::closeTag("div");        
    }
}
    