<?php

class EpaperEditionListWidget extends AbstractWidget {

    public $cat_id = 0;
    public $count = 5;
    public $format = self::FORMAT_LIST;
    public $order = self::ORDER_DATE_DESC;
    
    const FORMAT_LIST = "list";
    const FORMAT_LIST_DATE = "list_date";
    const FORMAT_DETAILS = "detail";
    const FORMAT_DETAILS_THUMB = "detail_thumb";

    const ORDER_ID_DESC = "ed_id desc";
    const ORDER_DATE_DESC = "ed_date desc";
    
    public function adminForm() {
        $formats = array(
            self::FORMAT_LIST => "Normal list",
            self::FORMAT_LIST_DATE => "Normal list with date",
            self::FORMAT_DETAILS => "With details",
            self::FORMAT_DETAILS_THUMB => "With Details and Thumbnail",
        );

        echo "<div class='form-group'>";
        echo $this->form->label($this, "cat_id");
        echo $this->form->dropDownList($this, "cat_id", EpaperCategory::model()->getFullHierarchyAsPlainArray(), array("class" => "form-control"));
        echo $this->form->error($this, "cat_id");
        echo "</div>";

        echo "<div class='form-group'>";
        echo $this->form->label($this, "count");
        echo $this->form->textField($this, "count", array("class" => "form-control"));
        echo $this->form->error($this, "count");
        echo "</div>";

        echo "<div class='form-group'>";
        echo $this->form->label($this, "format");
        echo $this->form->dropDownList($this, "format", $formats, array("class" => "form-control"));
        echo $this->form->error($this, "format");
        echo "</div>";
        
        $orders = array(
            self::ORDER_ID_DESC => "Id Descending",
            self::ORDER_DATE_DESC => "Date Descending",            
        );
        
        echo "<div class='form-group'>";
        echo $this->form->label($this, "order");
        echo $this->form->dropDownList($this, "order", $orders, array("class" => "form-control"));
        echo $this->form->error($this, "order");
        echo "</div>";
    }

    public function attributeLabels() {
        $lbl = parent::attributeLabels();
        $lbl["cat_id"] = "Category";
        return $lbl;
    }

    public function rules() {
        $rules = parent::rules();
        $rules[] = array("count, format, order, cat_id", "required");

        return $rules;
    }

    public function render($arg, $data) {
        $epaper_config = ModuleLoader::getConfig("epaper");
        $epaper_mediadir = Yii::app()->getBaseUrl(true) . Yii::app()->params['uploadDir'] . $epaper_config["mediaDir"];
        $r["title"] = $arg["title"];
        extract($data);

        $cri = new CDbCriteria();
        $cri->limit = $count;
        
        $cri->order = $order;        
        if ($cat_id > 0) {
            $cri->condition = "cat_id = :cat_id AND ed_status = 'public'";
            $cri->params[":cat_id"] = $cat_id;
        } else {
            $cri->condition = "ed_status = 'public'";            
        }
        $models = EpaperEdition::model()->findAll($cri);
$str = "";
        if (count($models) > 0) {
            if ($format == self::FORMAT_LIST || $format == self::FORMAT_LIST_DATE) {
                $str.= "<ul>";      
            } else {
                $str.= "<ul style='list-style:none'>";      
            }
            foreach($models as $m){
                if ($format == self::FORMAT_LIST || $format == self::FORMAT_LIST_DATE) {
                    $str.= "<li>";
                    $str.=CHtml::link(CHtml::encode($m->ed_title), Yii::app()->createUrl("//epaper/default/show", array("id" => $m->ed_id, "alias" => $m->ed_alias)));
                    if ($format == self::FORMAT_LIST_DATE) {
                        $str .= "<br /><span class='epost_date' style='font-size:0.8em; color:gray'>" . Helpers::i()->formatDate($m->ed_date, "F d, Y") . "</span>";
                    }
                    $str.= "</li>";
                } else {
                    
$str .= "<li class='clearfix'>";
                    if ($format == self::FORMAT_DETAILS_THUMB) {
                        if(trim($m->ed_image)!=""){                            
                           
                        $imageurl = $epaper_mediadir . $m->ed_image;                    
                        if (trim($m->ed_image) == "") {
                            $thumb = ImageHelpers::i()->getDefaultImage(75, 75, true);
                        } else {
                            $thumb = ImageHelpers::i()->getThumbImage($imageurl, 75, 75, true);
                        }                    
                        $imgtag = CHtml::image($thumb,CHtml::encode($m->ed_title));
                        $str .= CHtml::link($imgtag, Yii::app()->createUrl("//epaper/default/show", array("id" => $m->ed_id, "alias" => $m->ed_alias)),array("class"=>'pull-left thumbnail',"style"=>'margin-right:10px;'));                        
                        }  
                    }   

                    $str.= CHtml::link("<strong>".CHtml::encode($m->ed_title)."</strong>", Yii::app()->createUrl("//epaper/default/show", array("id" => $m->ed_id, "alias" => $m->ed_alias)));
                    $str.= "<br /><span class='epost-date' style='font-size:0.8em; color:gray'>" . Helpers::i()->formatDate($m->ed_date, "F d, Y") . "</span>";
                    $str.= "<p class='ed_desc' style='font-size:0.9em;'>" . Helpers::i()->wordLimiter($m->ed_desc) . "</p>";
                
                    $str.= "</li>";
                }
            }
            $str.= "</ul>";
        }

        $r["body"] = $str;
        return $r;
    }

}
