<?php
$config = ModuleLoader::getConfig("epaper");        
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];        
?>
<div class="btn-toolbar">
    <button type="button" name="btnNew" id="btnNew" class="btn btn-primary">New Category</button>
</div>

<table class="table">
    <thead>
        <tr>
            <th class="col-xs-2">Actions</th>
            <th>Category Name</th>
        </tr>
    </thead>
    <tbody id="tbodyList">
        
    </tbody>
</table>



<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'form',
    'htmlOptions' => array('class' => 'dialog-form', 'enctype' => 'multipart/form-data'),
    'action' => $this->createUrl("save"),
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:submitForm'
    )
        ));
?>
<div class="clearfix">
    <div class="col-xs-4">
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'cat_title'); ?>
            <?php echo $form->textField($formModel, 'cat_title', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'cat_title'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'cat_alias'); ?>
            <?php echo $form->textField($formModel, 'cat_alias', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'cat_alias'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'cat_desc'); ?>
            <?php echo $form->textArea($formModel, 'cat_desc', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'cat_desc'); ?>
        </div>

        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'cat_pid'); ?>
            <?php echo $form->dropDownList($formModel, 'cat_pid', EpaperCategory::model()->getFullHierarchyAsPlainArray(), array("class" => "form-control select-dotted")); ?>
            <?php echo $form->error($formModel, 'cat_pid'); ?>
        </div>
    </div>


    <div class="col-xs-4">

        <div class="imagepreview">
            <a href="" data-lightbox="image">
            <img class="thumbnail" src="" alt="" /></a><br />
            <div class="form-group">
                <?php echo $form->labelEx($formModel, 'deletefile'); ?>
                <?php echo $form->checkBox($formModel, 'deletefile'); ?>
                <?php echo $form->error($formModel, 'deletefile'); ?>
            </div>
        </div>
        <div class="form-group"> 

            <?php echo $form->labelEx($formModel, 'imagefile'); ?>
            <?php echo $form->fileField($formModel, 'imagefile',array("accept"=>"image/jpeg,image/png,image/gif")) ?>
            <?php echo $form->error($formModel, 'imagefile'); ?>
        </div>
    </div>

    <div class="col-xs-4"> 
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'cat_metadesc'); ?>
            <?php echo $form->textArea($formModel, 'cat_metadesc', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'cat_metadesc'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'cat_metakeys'); ?>
            <?php echo $form->textArea($formModel, 'cat_metakeys', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'cat_metakeys'); ?>
        </div>
    </div>

</div>

<p class="text-right">
    <?php echo CHtml::submitButton("Submit", array("id" => "formbtnSubmit", "class" => "btn btn-primary")); ?>	
</p>
<?php echo $form->hiddenField($formModel, 'cat_id'); ?>
<?php $this->endWidget(); ?>



<script>
 loadList();
 
$("#EpaperCategoryForm_imagefile").on("change",function(){
    var file_type = $(this).get(0).files[0].type.toLowerCase();
    var file_size = $(this).get(0).files[0].size;
    var max_file_size = <?php echo Helpers::i()->returnBytes(ini_get("upload_max_filesize")); ?>;

    if(file_size>max_file_size){
        $(this).val('');
        alert("File is larger than the maximum size allowed. Max upload size: <?php echo ini_get("upload_max_filesize") ?>");
    }

    if(file_type=="image/jpg" || file_type=="image/jpeg" || file_type=="image/png" || file_type=="image/gif"){

    } else {
       $(this).val('');
       alert("Only image files are allowed.");
    }
});
 
 
    //$("#form").dialog({autoOpen: false, width: 800, position: ['center', 'middle'], modal: true});
    $("#form").dialog({autoOpen: false, width: 800,modal:true});
    
    $("#btnNew").on("click", function() {
        $(".imagepreview input, .imagepreview label").hide();
        $(".imagepreview img").attr("src", "<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>");
        
        $("#form").dialog("open");
        $("#form").dialog("option", "title", "New");
        loadCategoryList(-1);       
        resetForm("#form");
         
    });


    $(document).on("click", ".linkbtn_delete", function(e) {
        e.preventDefault();
        var answer = confirm("Are you sure?");
        if(answer){
            var id = $(this).attr("data-id");
            $.ajax({
                data: {"id": id},
                url: "<?php echo $this->createUrl("delete"); ?>",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList();
                        }
                    }
                }
            });
        }
    });

    $(document).on("click", ".linkbtn_edit", function(e) {
        e.preventDefault();
        var id = $(this).attr("data-id");
        loadCategoryList(id);
        resetForm("#form");

        $.ajax({
            data: {"id": id},
            url: "<?php echo $this->createUrl("get"); ?>",
            success: function(data, textStatus, XMLHttpRequest) {
                if (serverValidation(data) == true) {
                    if (data.status == true) {
                        populateForm("#form", data.data.result, "EpaperCategoryForm");

                        var mdl = data.data.result;
                        if ($.trim(mdl.cat_image) != "") {
                            var imgsrc = "<?php echo Yii::app()->getBaseUrl() . $uploadDir.$mediaDir; ?>" + mdl.cat_image;
                            var thumbsrc = "<?php echo ImageHelpers::i()->getThumbImageSq("T_imgsrc", 200); ?>";
                            thumbsrc = thumbsrc.replace("T_imgsrc", imgsrc);
                            $(".imagepreview input, .imagepreview label").show();
                        } else {
                            var thumbsrc = "<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>";
                            $(".imagepreview input, .imagepreview label").hide();
                        }


                        $(".imagepreview img").attr("src", thumbsrc);
                        $(".imagepreview a").attr("href", imgsrc);
                        
                        $("#form").dialog("open");
                        $("#form").dialog("option", "title", "Edit");
                    } else {
                        alert("File Not Found");
                    }
                }
            }
        });
    });
    
    $(document).on("click", ".linkbtn_sendfront", function(e) {
        e.preventDefault();        
        var id = $(this).attr("data-id");             
         
        $.ajax({
        type: "POST",
        url: "<?php echo $this->createUrl("sendfront") ?>",
        data: { "id": id },
        success: function(response){
            if(serverValidation(response)){
                loadList();
            }
        },
        dataType: "json"
        });
         
    });
    $(document).on("click", ".linkbtn_removefront", function(e) {
        e.preventDefault();        
        var id = $(this).attr("data-id");             
        
        $.ajax({
        type: "POST",
        url: "<?php echo $this->createUrl("removefront") ?>",
        data: { "id": id },
        success: function(response){
            if(serverValidation(response)){
                loadList();
            }
        },
        dataType: "json"
        });
     
    });
    
    function submitForm(form, data, hasError) {
        
        if (!hasError) {
            form.ajaxSubmit({
                type:"post",
                dataType: "json",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList();
                            $("#form").dialog("close");
                        }
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    showError(textStatus, errorThrown);
                }
            });
        }
    }
    function loadCategoryList(exclude) {
        if (exclude == 1) {
            $("#EpaperCategoryForm_cat_pid").html("<option value='0'>None</option>");
            return;
        }
        $.post("<?php echo $this->createUrl("loadcategorylist") ?>", {id: exclude}, function(data) {
            $("#EpaperCategoryForm_cat_pid").html(data);
        }, "html");
    }
    function loadList() {
        $.get("<?php echo $this->createUrl("loadlist") ?>", {}, function(data) {
            $("#tbodyList").html(data);
        }, "html");
    }
  
</script>

<?php include "supp.php"; ?>