<div id="divSupp" title="Supplementry Page Categories">
    <p>
        <button id="divSupp_new" class="btn btn-primary">New</button>
    </p>
    <table class="table">
        <thead>
        <tr>
            <td class="col-xs-2">Actions</td>
            <td>Title</td>
            <td>Alias</td>
        </tr>
        </thead>
        <tbody id="divSupp_list">
            
        </tbody>
    </table> 
</div>
<input type="hidden" id="current_cat_id" value="" />
<?php
$suppModel = new EpaperSupp();
 
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'formSupp',
    'htmlOptions' => array('class' => 'dialog-form','title'=>'New'),
    'action' => $this->createUrl("suppsave"),
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:supp.save'
    )
        ));
?>
<div class="clearfix"> 
        <div class="form-group">
            <?php echo $form->labelEx($suppModel, 'sp_name'); ?>
            <?php echo $form->textField($suppModel, 'sp_name', array("class" => "form-control")); ?>
            <?php echo $form->error($suppModel, 'sp_name'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($suppModel, 'sp_alias'); ?>
            <?php echo $form->textField($suppModel, 'sp_alias', array("class" => "form-control")); ?>
            <?php echo $form->error($suppModel, 'sp_alias'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($suppModel, 'cat_id'); ?>
            <?php echo $form->dropDownList($suppModel, 'cat_id', EpaperCategory::model()->getFullHierarchyAsPlainArray(), array("class" => "form-control")); ?>
            <?php echo $form->error($suppModel, 'cat_id'); ?>
        </div>  
        <?php echo $form->hiddenField($suppModel, 'sp_id'); ?> 
</div>

<p class="text-right">
    <?php echo CHtml::submitButton("Submit", array("id" => "formbtnSubmit", "class" => "btn btn-primary")); ?>	
</p>

<?php $this->endWidget(); ?>

<script>
    var supp = {
        init : function(){
            //$("#divSupp").dialog({autoOpen: false, width: 800, position: ['center', 'middle'], modal: true});            
            //$("#formSupp").dialog({autoOpen: false, width: 300, position: ['center', 'middle'], modal: true}); 
            
            $("#divSupp").dialog({autoOpen: false, width: 800, modal: true});            
            $("#formSupp").dialog({autoOpen: false, width: 300, modal: true}); 
            
            $(document).on("click",".linkbtn_open",function(e){ e.preventDefault(); supp.open($(this).attr("data-id")); });
            
            $(document).on("click",".supp_linkbtn_edit",function(e){ e.preventDefault(); supp.get($(this).attr("data-id")); });
            $(document).on("click",".supp_linkbtn_delete",function(e){ e.preventDefault(); supp.delete($(this).attr("data-id")); });
            $(document).on("click",".supp_linkbtn_remove",function(e){ e.preventDefault(); supp.remove($(this).attr("data-id")); });
            
            $("#divSupp_new").on("click",function(){ supp.create(); });
            $(function() {
                $( "#divSupp_list" ).sortable({
                    axis: 'y',
                    update: function (event, ui) {
                        var data = $(this).sortable('serialize');

                        // POST to server using $.post or $.ajax
                        $.ajax({
                            data: data+"&cat_id="+$("#current_cat_id").val(),
                            type: 'POST',
                            url: '<?php echo $this->createUrl("suppreorder") ?>'
                        });
                    }
                });
                $( "#sortable" ).disableSelection(); 
            });  
        },
        open: function(id){
            $("#divSupp").dialog("open");
            $("#EpaperSupp_cat_id").val(id);
            $("#current_cat_id").val(id);
            supp.loadlist(id);
        },
        loadlist : function(id){
            $.ajax({
                "type":"post","dataType":"html",
                "data":{ id : id },
                "url":"<?php echo $this->createUrl("supplist") ?>",
                "success":function(response){
                    $("#divSupp_list").html(response);
                }
            });
        },
        get: function(id){
            $.ajax({
                "type":"post","dataType":"json",
                "data":{ id : id },
                "url":"<?php echo $this->createUrl("suppget") ?>",
                "success":function(response){
                    if(serverValidation(response)){
                        $("#EpaperSupp_sp_name").val(response.data.result.sp_name);
                        $("#EpaperSupp_sp_alias").val(response.data.result.sp_alias);
                        $("#EpaperSupp_cat_id").val(response.data.result.cat_id);
                        $("#EpaperSupp_sp_id").val(response.data.result.sp_id);
                        $("#formSupp").dialog("option","title","Edit");
                        $("#formSupp").dialog("open");
                    }
                }
            });
        },
        create : function(){
            $("#EpaperSupp_sp_name").val("");
            $("#EpaperSupp_sp_alias").val("");
            $("#formSupp").dialog("option","title","New");
            $("#formSupp").dialog("open");
        },
        save : function(form, data, hasError){
            if (!hasError) {
                form.ajaxSubmit({
                    type:"post",
                    dataType: "json",
                    success: function(data, textStatus, XMLHttpRequest) {
                        if (serverValidation(data) == true) {
                            if (data.status == true) {
                                supp.loadlist($("#current_cat_id").val());
                                $("#formSupp").dialog("close");
                            }
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        showError(textStatus, errorThrown);
                    }
                });
            }
        },
        delete: function(id){
            var answer = confirm("Are you sure? (This will NOT delete the pages)");
            if(answer){
                $.ajax({
                    "type":"post","dataType":"json",
                    "data":{ id : id},
                    "url":"<?php echo $this->createUrl("suppdelete") ?>",
                    "success":function(response){
                        supp.loadlist($("#current_cat_id").val());
                    }
                });
            }
        },
        remove: function(id){
            var answer = confirm("Are you sure? (This will ALSO DELETE the pages)");
            if(answer){
                $.ajax({
                    "type":"post","dataType":"json",
                    "data":{ id : id,remove:"remove" },
                    "url":"<?php echo $this->createUrl("suppdelete") ?>",
                    "success":function(response){
                        supp.loadlist($("#current_cat_id").val());
                    }
                });
            }
        }
    };
    supp.init(); 
     
    
</script>
