<?php
$config = ModuleLoader::getConfig("epaper");        
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];        

?>
<div class="btn-toolbar clearfix">
    
        <button type="button" name="btnNew" id="btnNew" class="btn btn-primary">New Edition</button>
 
    <div class="pull-right">
        <div class="form-inline">
        <?php echo CHtml::dropDownList("cat_id", 0, EpaperCategory::model()->getFullHierarchyAsPlainArray(0,true),array("encode"=>false, "class"=>"form-control select-dotted")); ?>
        <?php echo CHtml::textField("search","",array("class"=>"form-control","placeholder"=>"Enter search terms here...")); ?>        
        <?php echo CHtml::htmlButton("Search",array("class"=>"btn btn-primary","id"=>"btnSearch")); ?>
            <?php echo CHtml::htmlButton("Reset",array("class"=>"btn btn-default","id"=>"btnReset")); ?>
        </div>
    </div>
</div>

<table class="table">
    <thead>
        <tr>
            <th class="col-xs-3">Actions</th>
            <th>Edition Title</th>
            <th>Category</th>
            <th>Date</th>            
            <th>Status</th>
        </tr>
    </thead>
    <tbody id="tbodyList">
        
    </tbody>
    <tfoot>
        <tr>
            <td colspan="5">
                <div id="pager" class="pager"></div>
            </td>
        </tr>
    </tfoot>
</table>

<!-- Templates -->
<p style="display:none">
    <textarea id="templateList" rows="0" cols="0">
<!--      
    {#foreach $T.records as r}
        <tr>
            <td>

<a data-id="{$T.r.ed_id}" class="linkbtn_open btn btn-primary btn-xs" href="<?= urldecode($this->createUrl("admin/page/index",array("ed_id"=>'{$T.r.ed_id}'))) ?>">Upload Pages</a>

                
                <?php echo AdminHelpers::i()->linkbtnEdit('{$T.r.ed_id}'); ?> 
{#if $T.r.fed_id == null} 
<a class='linkbtn_sendfront btn btn-default btn-xs' title='Send to Frontpage' data-id='{$T.r.ed_id}' href='#'><i class='glyphicon glyphicon-plus'></i></a>
{#else} 
<a class='linkbtn_removefront btn btn-warning btn-xs' title='Remove from Frontpage' data-id='{$T.r.ed_id}' href='#'><i class='glyphicon glyphicon-minus'></i></a>
{#/if} 
<?php echo AdminHelpers::i()->linkbtnDelete('{$T.r.ed_id}'); ?>
<?php if(EpaperSettings::i()->enable_bookmarks){ ?>
&nbsp;
<a class='linkbtn_bookmark btn btn-primary btn-xs' title='Manage Bookmarks' data-id='{$T.r.ed_id}' href='<?php echo urldecode($this->createUrl("admin/bookmark/index",array("id"=>'{$T.r.ed_id}'))); ?>'><i class='glyphicon glyphicon-bookmark'></i></a>
<?php } ?>

</td>
            <td>{$T.r.ed_title}</td>
<td>{$T.r.cat_title}</td>
            <td>{$T.r.ed_date}</td>
            <td>
<span class='label 
{#if $T.r.ed_status == 'private'} 
label-danger
{#else} 
label-success
{#/if} 
'>
{$T.r.ed_status}</span></td>
        </tr> 
    {#/for}
-->
    </textarea>
</p>
<!-- //Templates -->

<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'form',
    'htmlOptions' => array('class' => 'dialog-form', 'enctype' => 'multipart/form-data'),
    'action' => $this->createUrl("save"),
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:submitForm'
    )
        ));
?>
<div class="clearfix">
<div class="col-xs-4">
<div class="form-group">
    <?php echo $form->labelEx($formModel, 'ed_title'); ?>
    <?php echo $form->textField($formModel, 'ed_title', array("class" => "form-control")); ?>
    <?php echo $form->error($formModel, 'ed_title'); ?>
</div>
<div class="form-group">
    <?php echo $form->labelEx($formModel, 'ed_alias'); ?>
    <?php echo $form->textField($formModel, 'ed_alias', array("class" => "form-control")); ?>
    <?php echo $form->error($formModel, 'ed_alias'); ?>
</div>
<div class="form-group">
    <?php echo $form->labelEx($formModel, 'ed_desc'); ?>
    <?php echo $form->textArea($formModel, 'ed_desc', array("class" => "form-control")); ?>
    <?php echo $form->error($formModel, 'ed_desc'); ?>
</div>
<div class="form-group">
    <?php echo $form->labelEx($formModel, 'ed_date'); ?>
    <?php echo $form->textField($formModel, 'ed_date', array("class" => "form-control")); ?>
    <?php echo $form->error($formModel, 'ed_date'); ?>
</div>
</div>
<div class="col-xs-4">
    
 <div class="form-group"> 
    <?php echo $form->labelEx($formModel, 'imagefile'); ?>
    <?php echo $form->fileField($formModel, 'imagefile',array("accept"=>"image/jpeg,image/png,image/gif")) ?>
    <?php echo $form->error($formModel, 'imagefile'); ?>
</div>
<div class="imagepreview">
    
    <div class="form-group">
        <a target="_blank" data-lightbox="image" href="#"><img src="" class="thumbnail" alt="" /></a> 
        <?php echo $form->labelEx($formModel, 'delete_image'); ?>
        <?php echo $form->checkBox($formModel, 'delete_image'); ?>
        <?php echo $form->error($formModel, 'delete_image'); ?>
    </div>
</div>

 
<br /> 

<div class="form-group"> 
    <?php echo $form->labelEx($formModel, 'pdffile'); ?>
    <?php echo $form->fileField($formModel, 'pdffile',array("accept"=>"application/pdf")) ?>
    <?php echo $form->error($formModel, 'pdffile'); ?>
</div>
<div class="pdfpreview">
    
    <div class="form-group">
        <a target="_blank" class="btn btn-danger btn-xs" href="">Download PDF</a>
  
        <?php echo $form->labelEx($formModel, 'delete_pdf'); ?>
        <?php echo $form->checkBox($formModel, 'delete_pdf'); ?>
        <?php echo $form->error($formModel, 'delete_pdf'); ?>
    </div>
</div>

</div>
<div class="col-xs-4">
<div class="form-group">
    <?php echo $form->labelEx($formModel, 'cat_id'); ?>
    <?php echo $form->dropDownList($formModel, 'cat_id', EpaperCategory::model()->getFullHierarchyAsPlainArray(0,false), array("encode"=>false, "class" => "form-control select-dotted")); ?>
    <?php echo $form->error($formModel, 'cat_id'); ?>
</div>


<div class="form-group">
    <?php echo $form->labelEx($formModel, 'ed_status'); ?>
    <?php echo $form->dropDownList($formModel, 'ed_status', array("private"=>"Private","public"=>"Public"), array("class" => "form-control")); ?>
    <?php echo $form->error($formModel, 'ed_status'); ?>
</div>


<div class="form-group">
    <?php echo $form->labelEx($formModel, 'ed_metadesc'); ?>
    <?php echo $form->textArea($formModel, 'ed_metadesc', array("class" => "form-control")); ?>
    <?php echo $form->error($formModel, 'ed_metadesc'); ?>
</div>
<div class="form-group">
    <?php echo $form->labelEx($formModel, 'ed_metakeys'); ?>
    <?php echo $form->textArea($formModel, 'ed_metakeys', array("class" => "form-control")); ?>
    <?php echo $form->error($formModel, 'ed_metakeys'); ?>
</div>
</div>

</div>

<p class="text-right">
    <?php echo CHtml::submitButton("Submit", array("id" => "formbtnSubmit", "class" => "btn btn-primary")); ?>	
</p>
<?php echo $form->hiddenField($formModel, 'ed_id'); ?>
<?php $this->endWidget(); ?>

<script>
 
    var page = 1;
    var total = 0;
    var perpage = <?php echo $this->perpage ?>;
    
    loadList(1);
    
    function getPageCount() {
        if (total > 0) {
            return Math.ceil(total /perpage);
        }
        return 0;
    }
    
    function pageClick(pageclickednumber) {
        $("#pager").pager({pagenumber: pageclickednumber, pagecount: getPageCount(), buttonClickCallback: pageClick});
        loadList(pageclickednumber);
    }
    
    function loadList(cpage){
        var search = $("#search").val();
        var cat_id = $("#cat_id").val();
        $.ajax({
            data: {"page": cpage, "search": search, "cat_id":cat_id },
            url: "<?php echo $this->createUrl("loadlist"); ?>",
            success: function(response, textStatus, XMLHttpRequest) {
                if (serverValidation(response) == true) {
                    if (response.status == true) {
                        $("#tbodyList").setTemplateElement("templateList").processTemplate(response.data.result);
                        total = response.data.result.total;
                    } else {
                        $("#tbodyList").html("No Records Found");
                    }
                }

                page = cpage;
                if (page == 1) {
                    $("#pager").pager({pagenumber: page, pagecount: getPageCount(), buttonClickCallback: pageClick});
                }
            }
        });
    }
    
    function submitForm(form, data, hasError) { 
        if (!hasError) {
             
            form.ajaxSubmit({
                type:"post",
                dataType: "json",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList(page);
                            $("#form").dialog("close");
                        }
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    showError(textStatus, errorThrown);
                }
            });
        }
    }
    
    
    $("#EpaperEditionForm_imagefile").on("change",function(){
        var file_type = $(this).get(0).files[0].type.toLowerCase();
        var file_size = $(this).get(0).files[0].size;
        var max_file_size = <?php echo Helpers::i()->returnBytes(ini_get("upload_max_filesize")); ?>;

        if(file_size>max_file_size){
            $(this).val('');
            alert("File is larger than the maximum size allowed. Max upload size: <?php echo ini_get("upload_max_filesize") ?>");
        }

        if(file_type=="image/jpg" || file_type=="image/jpeg" || file_type=="image/png" || file_type=="image/gif"){

        } else {
           $(this).val('');
           alert("Only image files are allowed.");
        }
    });
    
    $("#EpaperEditionForm_pdffile").on("change",function(){
        var file_type = $(this).get(0).files[0].type.toLowerCase();
        var file_size = $(this).get(0).files[0].size;
        var max_file_size = <?php echo Helpers::i()->returnBytes(ini_get("upload_max_filesize")); ?>;
        
        if(file_size>max_file_size){
            $(this).val('');
            alert("File is larger than the maximum size allowed. Max upload size: <?php echo ini_get("upload_max_filesize") ?>");
        }

        console.log(file_type);
        if(file_type!=="application/pdf" && file_type!=="binary/octet-stream"){
            $(this).val('');
            alert("Only pdf files are allowed.");
        }  
    });
    
    
    
    
    $("#btnSearch").on("click",function(){
        loadList(1);
    });
    $("#btnReset").on("click",function(){
        $("#search").val("");
        $("#cat_id").val(0);
        loadList(1);
    });
    //$("#form").dialog({autoOpen: false, width: 800, position: ['center', 'middle'], modal: true});
    $("#form").dialog({autoOpen: false, width: 800,  modal: true});
    $("#EpaperEditionForm_ed_date").datepicker({
        dateFormat: "dd M yy",
        changeYear: true,
        changeMonth: true,
        yearRange: '1995:2050'
    });
    $("#btnNew").on("click", function() {
        $(".imagepreview img").attr("src", "<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>");
        $(".imagepreview a").attr("href", "#");
        $(".imagepreview input,.imagepreview label , .pdfpreview a, .pdfpreview input, .pdfpreview label").hide();
        $("#form").dialog("open");
        $("#form").dialog("option", "title", "New");        
        resetForm("#form");
    });
    
    
    
    $(document).on("click", ".linkbtn_delete", function(e) {
        e.preventDefault();
        var answer = confirm("Are you sure?");
        if(answer){
            var id = $(this).attr("data-id");
            $.ajax({
                data: {"id": id},
                url: "<?php echo $this->createUrl("delete"); ?>",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList(page);
                        }
                    }
                }
            });
        }
    });
    
    
    
    //incomplete
    $(document).on("click", ".linkbtn_edit", function(e) {
        e.preventDefault();
        var id = $(this).attr("data-id"); 
        resetForm("#form"); 
        $.ajax({
            data: {"id": id},
            url: "<?php echo $this->createUrl("get"); ?>",
            success: function(data, textStatus, XMLHttpRequest) {
                if (serverValidation(data) == true) {
                    if (data.status == true) {
                        populateForm("#form", data.data.result, "EpaperEditionForm");

                        var mdl = data.data.result;
                        
                        if ($.trim(mdl.ed_image) != "") {
                            var imgsrc = "<?php echo Yii::app()->getBaseUrl() . $uploadDir.$mediaDir; ?>" + mdl.ed_image;
                            var thumbsrc = "<?php echo ImageHelpers::i()->getThumbImageSq("T_imgsrc", 200); ?>";
                            thumbsrc = thumbsrc.replace("T_imgsrc", imgsrc);
                            $(".imagepreview input, .imagepreview label").show();
                        } else {
                            var imgsrc = "#";
                            var thumbsrc = "<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>";
                            $(".imagepreview input, .imagepreview label").hide();
                        }
                         
                        if ($.trim(mdl.ed_pdf) != "") {
                            var pdflink = "<?php echo Yii::app()->getBaseUrl() . $uploadDir.$mediaDir; ?>" + mdl.ed_pdf;
                            
                            $(".pdfpreview input, .pdfpreview label, .pdfpreview a").show();
                        } else {
                            var pdflink = "";
                            $(".pdfpreview input, .pdfpreview label, .pdfpreview a").hide();
                        }
                        $(".pdfpreview a").attr("href", pdflink);                         
                        $(".imagepreview img").attr("src", thumbsrc);
                        $(".imagepreview a").attr("href", imgsrc);
                        
                        $("#form").dialog("open");
                        $("#form").dialog("option", "title", "Edit");
                    } else {
                        alert("File Not Found");
                    }
                }
            }
        });
    });


    $(document).on("click", ".linkbtn_sendfront", function(e) {
        e.preventDefault();        
        var id = $(this).attr("data-id");             
         
        $.ajax({
        type: "POST",
        url: "<?php echo $this->createUrl("sendfront") ?>",
        data: { "id": id },
        success: function(response){
            if(serverValidation(response)){
                loadList(page);
            }
        },
        dataType: "json"
        });
         
    });
    $(document).on("click", ".linkbtn_removefront", function(e) {
        e.preventDefault();        
        var id = $(this).attr("data-id");             
        
        $.ajax({
        type: "POST",
        url: "<?php echo $this->createUrl("removefront") ?>",
        data: { "id": id },
        success: function(response){
            if(serverValidation(response)){
                loadList(page);
            }
        },
        dataType: "json"
        });
     
    });
</script>