<?php
$config = ModuleLoader::getConfig("epaper");
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];
$image_path = Yii::getPathOfAlias("webroot") . $uploadDir . $mediaDir . $model->pg_file;
$image_url = Yii::app()->getBaseUrl(true) . $uploadDir . $mediaDir . $model->pg_file;
$wimg = WideImage::load($image_path);
$image_width = $wimg->getWidth();
?>
<style> 
    .area-saved{
        background-color:rgba(0,150,255,0.3);
        border:1px solid black;
    }
    .area-saved .btnSave{
        display:none;
    }
    .area-unsaved{
        background-color:rgba(0,0,0,0.3);
        border:1px dotted red;
    } 
    .btnEdit, .btnDelete, .btnSave{
        top:-30px;
        position:absolute;
    }
    .btnEdit{
        left:0px;        
    }
    .btnDelete{
        left:30px;        
    }
    .btnSave{
        left:60px;
    }
</style>
 

<div class="btn-toolbar">
    <div class="btn-group">
        <button name="btnAdd" id="btnAdd" value="Add" class="btn btn-danger">+ Add Area Map</button>
    </div>
</div>










<div id="canvas">
     
    
    <img style="width:100%; height:auto"  src="<?php echo $image_url; ?>" />
</div>

<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'form',
    'htmlOptions' => array('class' => 'dialog-form', 'enctype' => 'multipart/form-data'),
    'action' => $this->createUrl("save"),
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:submitForm'
    )
        ));
?>
<div class="clearfix">
    
    <div id="tabs">
        <ul>
            <li><a href="#tabs-1">Basic</a></li>
            <li><a href="#tabs-2">Description</a></li>
            
        </ul>
        <div id="tabs-1">
            
    <div class="col-xs-4">
    <div class="form-group">
        <?php echo $form->labelEx($formModel, 'title'); ?>
        <?php echo $form->textField($formModel, 'title', array("class" => "form-control")); ?>
        <?php echo $form->error($formModel, 'title'); ?>
    </div>
    <div class="form-group">
        <?php echo $form->labelEx($formModel, 'alias'); ?>
        <?php echo $form->textField($formModel, 'alias', array("class" => "form-control")); ?>
        <?php echo $form->error($formModel, 'alias'); ?>
    </div>
    <div class="form-group">
        <?php echo $form->labelEx($formModel, 'next_link_id'); ?>
        <?php echo $form->textField($formModel, 'next_link_id', array("class" => "form-control")); ?>
        <?php echo $form->error($formModel, 'next_link_id'); ?>
    </div>
    
    

    </div>
    <div class="col-xs-4">

     <div class="form-group"> 
        <?php echo $form->labelEx($formModel, 'file'); ?>
        <?php echo $form->fileField($formModel, 'file',array("accept"=>"image/jpeg,image/png,image/gif")) ?>
        <?php echo $form->error($formModel, 'file'); ?>
    </div>
    <div class="imagepreview"> 
        <div class="form-group">
            <a target="_blank" data-lightbox="image" href="#"><img src="" class="thumbnail" alt="" /></a> 
            <?php echo $form->labelEx($formModel, 'delete_image'); ?>
            <?php echo $form->checkBox($formModel, 'delete_image'); ?>
            <?php echo $form->error($formModel, 'delete_image'); ?>
        </div>
    </div> 
    </div>
    <div class="col-xs-4"> 
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'metadesc'); ?>
            <?php echo $form->textArea($formModel, 'metadesc', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'metadesc'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'metakeys'); ?>
            <?php echo $form->textArea($formModel, 'metakeys', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'metakeys'); ?>
        </div>
         
    </div>
        </div>
        <div id="tabs-2">
                
    <div class="form-group">
        <?php echo $form->labelEx($formModel, 'description'); ?>
        <?php echo $form->textArea($formModel, 'description', array("class" => "form-control","style"=>"height:280px")); ?>
        <?php echo $form->error($formModel, 'description'); ?>
    </div>
        </div>
         
    </div>
    
    

</div>

<p class="text-right">
    <?php echo CHtml::submitButton("Submit", array("id" => "formbtnSubmit", "class" => "btn btn-primary")); ?>	
</p>
<?php echo $form->hiddenField($formModel, 'map_id'); ?>
<?php $this->endWidget(); ?>















<?php include "index_js.php" ?>