<script src="<?php echo AssetsManager::i()->getCoreAsset("js/tinymce/tinymce.min.js"); ?>"></script>
<script>
    
  
 var desc = tinymce.init({
        height: 200,
        plugins: [
            'advlist autolink lists link image charmap print preview hr anchor pagebreak',
            'searchreplace wordcount visualblocks visualchars code fullscreen',
            'insertdatetime media nonbreaking save table contextmenu directionality',
            'emoticons template paste textcolor colorpicker textpattern imagetools'
        ],
     //   toolbar1: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
     //   toolbar2: 'print preview media | forecolor backcolor emoticons',
        selector: '#EpaperMapForm_description',
        setup: function (ed) {
            ed.on('keyup', function (e) {
                $("#EpaperMapForm_description").val(ed.getContent());
            });
            ed.on('change', function (e) {
                $("#EpaperMapForm_description").val(ed.getContent());
            });
        }

    }); 
    
  $(function() {
    $( "#tabs" ).tabs();
  });
 
    
    var originalSize = "<?php echo $image_width; ?>";
    var canvasSize = parseInt($("#canvas").css("width"));
    var ratio = formatNumber(originalSize / canvasSize,4);
     
    var Helpers = {
        getUID : function(){        
            var x = Math.floor((Math.random() * 1000) + 1);
            var y = Math.floor((Math.random() * 2000) + 1000);
            var z = Date.now();
            return "uid-" + (x * y * z).toString();        
        }
    }
    
    function Map(x, y, w, h, mapid) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.ratio = ratio;
        this.mapid = mapid;
        this.pg_id = <?php echo $model->pg_id ?>;
        this.id = Helpers.getUID();
    }
    
    var MapCollection = new function(){        
        this.collection = [];
      
        this.add = function(map){
            this.collection.push(map);    
            MapCollectionCanvas.add(map);
             
            return map.id;
        };
        this.removeByIndex = function(index){
            MapCollectionCanvas.remove(this.collection[index].id);
            this.collection.splice(index, 1 );
             
        };
        this.removeById = function(id){                  
            var index = this.getIndexById(id);
            this.removeByIndex(index);
        };         
        this.getIndexById = function(id){
            for (var k in this.collection) {
                if (this.collection[k].id === id) {
                    return k;
                }
            }
        };   
        this.getIndexByMapId = function(mapid){
            for (var k in this.collection) {
                if (this.collection[k].mapid === mapid) {
                    return k;
                }
            }
        };
    };
    
    var MapCollectionCanvas = new function(){
        var alive = function (id) {
            var index = MapCollection.getIndexById(id);
             
            MapCollection.collection[index].w = parseFloat($("#" + id).css("width"))+12;
            MapCollection.collection[index].h = parseFloat($("#" + id).css("height"))+12;
            MapCollection.collection[index].x = parseFloat($("#" + id).css("left"));
            MapCollection.collection[index].y = parseFloat($("#" + id).css("top"));
            $("#" + id).removeClass("area-saved").addClass("area-unsaved");
        };
		var alive2 = function (id) {
            var index = MapCollection.getIndexById(id);
             
            MapCollection.collection[index].w = parseFloat($("#" + id).css("width"))+12;
            MapCollection.collection[index].h = parseFloat($("#" + id).css("height"))+12;
            MapCollection.collection[index].x = parseFloat($("#" + id).css("left"));
            MapCollection.collection[index].y = parseFloat($("#" + id).css("top"));
             
        };
        this.add = function(map){
            var activeclass = "";
            if (map.mapid !== undefined) {
                activeclass = "area-saved"
            } else {
                activeclass = "area-unsaved"
            }
            var string = '<div id="' + map.id + '" data-id="' + map.id + '" data-mapid="' + map.mapid + '" class="area ' + activeclass + ' " style="box-sizing: content-box; top: ' + (map.y / map.ratio) + 'px; left: ' + (map.x / map.ratio) + 'px; width: ' + ((map.w / map.ratio) - 12) + 'px; height: ' + ((map.h / map.ratio) - 12) + 'px;">';
            
            string += '<a href="#" data-id="' + map.id + '" class="btnSave btn btn-primary btn-xs"><span class=" glyphicon glyphicon-floppy-disk"></span></a> ';
            string += '<a href="#" data-id="' + map.id + '" class="btnEdit btn btn-success btn-xs"><span class="glyphicon glyphicon-pencil"></span></a> ';
            string += '<a href="#" data-id="' + map.id + '" class="btnDelete btn btn-danger btn-xs"><span class="glyphicon glyphicon-trash"></span></a>  ';
            string += "</div>";
            $("#canvas").append(string);   
            alive2(map.id);
            $(".area").resizable({
                handles: "n, e, s, w, nw, ne, sw, se",
                minHeight: 1,
                minWidth: 1,
                resize: function (e,ui) {   
                    var id = $(this).attr("id");  
//                    var w = parseFloat($("#" + id).css("width"));
//                    var h = parseFloat($("#" + id).css("height"));
//                     
//                    $("#" + id).css("width", w + "px");
//                    $("#" + id).css("height", h + "px");
                    alive(id);
                }
            }).draggable({
                drag: function () {
                    var id = $(this).attr("id");
                     alive(id);
                }
            });
            
            
             
        };
        this.remove = function (id) {
            var mapid = $("#"+id).attr("data-mapid"); 
          
            if(mapid==="undefined"||mapid===""){
                $("#" + id).remove();
            } else {
                if(confirm("Are you sure?")){
                    $.ajax({
                        data: { mapid : mapid },
                        url: "<?php echo $this->createAbsoluteUrl("delete") ?>",
                        success: function (response) {                            
                            $("#" + id).remove();
                        }
                    });
                }
            } 
        };
        this.save = function(id){
            var index = MapCollection.getIndexById(id);               
            $.ajax({                 
                data: MapCollection.collection[index],
                url: "<?php echo $this->createAbsoluteUrl("savemap") ?>",
                success: function (response) {
                    $("#" + id).attr("data-mapid", response.data.result.id).removeClass("area-unsaved").addClass("area-saved");
                    MapCollection.collection[index].mapid =  response.data.result.id;
                    
                    document.dispatchEvent(new CustomEvent("afterSavingMap"));                   
                }
            });
        };
    };
    
     function resetCurrentForm(){
            $("#EpaperMapForm_file").val("");
            
            $("#EpaperMapForm_next_link_id").val("");
            $("#EpaperMapForm_previous_link_id").val("");
            
            $("#EpaperMapForm_map_id").val("");
            $("#EpaperMapForm_title").val("");
            $("#EpaperMapForm_description").val("");
            $("#EpaperMapForm_metadesc").val("");
            $("#EpaperMapForm_metakeys").val("");
            $("#EpaperMapForm_image").attr("src","<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>");
            $("#EpaperMapForm_delete_image").prop("checked",false);
    }
    function submitForm(form, data, hasError) { 
        if (!hasError) {             
            form.ajaxSubmit({
                type:"post",
                dataType: "json",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {                             
                            $("#form").dialog("close");
                        }
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    showError(textStatus, errorThrown);
                }
            });
        }
    }
     
    <?php
    if (count($mapModels) > 0) {
        foreach ($mapModels as $m) {
            ?>
               MapCollection.add(new Map(<?= $m->mp_x ?>, <?= $m->mp_y  ?>, <?= $m->mp_w  ?>, <?= $m->mp_h  ?>, <?= $m->mp_id ?>));
            <?php
        }
    }
    ?>
        
   
    //$("#form").dialog({autoOpen: false, width: 800, position: ['center', 'middle'], modal: true});
    $("#form").dialog({autoOpen: false, width: 800,  modal: true});
    $("#btnAdd").on("click", function () {
        var id = MapCollection.add(new Map(0, 0, 150*ratio, 150*ratio));         
    });
    $(document).on("click", ".btnSave", function (e) {
        e.preventDefault();
        var id = $(this).attr("data-id");
        $(document).off("afterSavingMap");
        MapCollectionCanvas.save(id);
    });
    $(document).on("click", ".btnDelete", function (e) {  
        e.preventDefault();
        var id = $(this).attr("data-id");           
        MapCollection.removeById(id);
    });
    
    $(document).on("click", ".btnEdit", function (e) {
        e.preventDefault();
        var get = function(){
            
            resetCurrentForm();
            
            var mapid = $("#"+id).attr("data-mapid");
            $.ajax({
               data: { mapid : mapid },
               url: "<?php echo $this->createUrl("get"); ?>",
               success:function(data){
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                             
                            populateForm("#form", data.data.result, "EpaperMapForm");

                            var mdl = data.data.result;

                            if ($.trim(mdl.image) != "") {
                                var imgsrc = "<?php echo Yii::app()->getBaseUrl() . $uploadDir.$mediaDir; ?>" + mdl.image;
                                var thumbsrc = "<?php echo ImageHelpers::i()->getThumbImageSq("T_imgsrc", 200); ?>";
                                thumbsrc = thumbsrc.replace("T_imgsrc", imgsrc);
                                $(".imagepreview input, .imagepreview label").show();
                            } else {
                                var imgsrc = "#";
                                var thumbsrc = "<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>";
                                $(".imagepreview input, .imagepreview label").hide();
                            }
                            
                             
                            tinyMCE.get('EpaperMapForm_description').setContent(mdl.description);
                            
                            $(".imagepreview img").attr("src", thumbsrc);
                            $(".imagepreview a").attr("href", imgsrc);

                            $("#form").dialog("open");
                            $("#form").dialog("option", "title", "Edit - "+mdl.map_id);
                        } else {
                            alert("File Not Found");
                        }
                    }
               }
            }); 
        };
        
        
        var id = $(this).attr("data-id");
        $(document).off("afterSavingMap");
        $(document).on("afterSavingMap",get);        
        MapCollectionCanvas.save(id);
    });
</script>

